/*
 * Decompiled with CFR 0.152.
 */
package opennlp.ccg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import opennlp.ccg.grammar.Grammar;
import opennlp.ccg.hylo.HyloHelper;
import opennlp.ccg.hylo.Nominal;
import opennlp.ccg.lexicon.Tokenizer;
import opennlp.ccg.parse.ParseException;
import opennlp.ccg.parse.Parser;
import opennlp.ccg.parse.Supertagger;
import opennlp.ccg.parse.supertagger.WordAndPOSDictionaryLabellingStrategy;
import opennlp.ccg.synsem.Category;
import opennlp.ccg.synsem.LF;
import opennlp.ccg.synsem.Sign;
import opennlp.ccg.synsem.SignScorer;
import opennlp.ccg.test.DerivMaker;
import opennlp.ccg.test.RegressionInfo;
import opennlp.ccgbank.extract.Testbed;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Parse {
    public static void main(String[] args) throws IOException {
        String line;
        String usage = "Usage: java opennlp.ccg.Parse \n  (-g <grammarfile>) \n  -parsescorer <scorerclass> \n  -supertagger <supertaggerclass> | -stconfig <configfile> \n  (-nbestListSize <nbestListSize>) \n  (-includederivs) \n  (-includescores) \n  <inputfile> <outputfile>";
        if (args.length == 0 || args[0].equals("-h")) {
            System.out.println(usage);
            System.exit(0);
        }
        String grammarfile = "grammar.xml";
        String inputfile = null;
        String outputfile = null;
        String parseScorerClass = null;
        String supertaggerClass = null;
        String stconfig = null;
        boolean includederivs = false;
        boolean includescores = false;
        int nbestListSize = 1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-g")) {
                grammarfile = args[++i];
                continue;
            }
            if (args[i].equals("-parsescorer")) {
                parseScorerClass = args[++i];
                continue;
            }
            if (args[i].equals("-supertagger")) {
                supertaggerClass = args[++i];
                continue;
            }
            if (args[i].equals("-stconfig")) {
                stconfig = args[++i];
                continue;
            }
            if (args[i].equals("-nbestListSize")) {
                nbestListSize = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-includederivs")) {
                includederivs = true;
                continue;
            }
            if (args[i].equals("-includescores")) {
                includescores = true;
                continue;
            }
            if (inputfile == null) {
                inputfile = args[i];
                continue;
            }
            outputfile = args[i];
        }
        if (nbestListSize < 1) {
            nbestListSize = 1;
        }
        if (inputfile == null || outputfile == null || parseScorerClass == null || supertaggerClass == null && stconfig == null) {
            System.out.println(usage);
            System.exit(0);
        }
        Document outDoc = new Document();
        Element outRoot = new Element("regression");
        outDoc.setRootElement(outRoot);
        HashMap<String, Sign> signMap = new HashMap<String, Sign>();
        URL grammarURL = new File(grammarfile).toURI().toURL();
        System.out.println("Loading grammar from URL: " + grammarURL);
        Grammar grammar = new Grammar(grammarURL);
        Tokenizer tokenizer = grammar.lexicon.tokenizer;
        System.out.println();
        Parser parser = new Parser(grammar);
        try {
            System.out.println("Instantiating parsing sign scorer from class: " + parseScorerClass);
            SignScorer parseScorer = (SignScorer)Class.forName(parseScorerClass).newInstance();
            parser.setSignScorer(parseScorer);
            System.out.println();
        }
        catch (Exception exc) {
            throw (RuntimeException)new RuntimeException().initCause(exc);
        }
        try {
            Supertagger supertagger;
            if (supertaggerClass != null) {
                System.out.println("Instantiating supertagger from class: " + supertaggerClass);
                supertagger = (Supertagger)Class.forName(supertaggerClass).newInstance();
            } else {
                System.out.println("Instantiating supertagger from config file: " + stconfig);
                supertagger = WordAndPOSDictionaryLabellingStrategy.supertaggerFactory(stconfig);
            }
            parser.setSupertagger(supertagger);
            System.out.println();
        }
        catch (Exception exc) {
            throw (RuntimeException)new RuntimeException().initCause(exc);
        }
        BufferedReader in = new BufferedReader(new FileReader(inputfile));
        HashMap<String, String> predInfoMap = new HashMap<String, String>();
        System.out.println("Parsing " + inputfile);
        System.out.println();
        int count = 1;
        while ((line = in.readLine()) != null) {
            String id = "s" + count;
            try {
                System.out.println(line);
                parser.parse(line);
                int numParses = Math.min(nbestListSize, parser.getResult().size());
                for (int i = 0; i < numParses; ++i) {
                    Sign thisParse = parser.getResult().get(i);
                    Category cat = thisParse.getCategory();
                    LF convertedLF = null;
                    String predInfo = null;
                    if (cat.getLF() != null) {
                        LF flatLF = cat.getLF();
                        cat = cat.copy();
                        Nominal index = cat.getIndexNominal();
                        convertedLF = HyloHelper.compactAndConvertNominals(flatLF, index, thisParse);
                        predInfoMap.clear();
                        Testbed.extractPredInfo(flatLF, predInfoMap);
                        predInfo = Testbed.getPredInfo(predInfoMap);
                    }
                    Element item = RegressionInfo.makeTestItem(grammar, line, 1, convertedLF);
                    String actualID = nbestListSize == 1 ? id : id + "-" + (i + 1);
                    item.setAttribute("info", actualID);
                    item.setAttribute("test", "true");
                    outRoot.addContent((Content)item);
                    signMap.put(actualID, thisParse);
                    Element fullWordsElt = new Element("full-words");
                    fullWordsElt.addContent(tokenizer.format(thisParse.getWords()));
                    item.addContent((Content)fullWordsElt);
                    if (predInfo != null) {
                        Element predInfoElt = new Element("pred-info");
                        predInfoElt.setAttribute("data", predInfo);
                        item.addContent((Content)predInfoElt);
                    }
                    if (includederivs) {
                        Element derivElt = new Element("deriv");
                        derivElt.addContent((Content)DerivMaker.makeDeriv(thisParse));
                        item.addContent((Content)derivElt);
                    }
                    if (!includescores) continue;
                    String score = parser.getScores().get(i).toString();
                    item.setAttribute("score", score);
                }
            }
            catch (ParseException e) {
                System.out.println("Unable to parse!");
                Element item = RegressionInfo.makeTestItem(grammar, line, 0, null);
                item.setAttribute("info", id);
                outRoot.addContent((Content)item);
            }
            ++count;
        }
        System.out.println();
        System.out.println("Writing parses to " + outputfile);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        File regressionFile = new File(outputfile);
        outputter.output(outDoc, (OutputStream)new FileOutputStream(regressionFile));
        RegressionInfo.writeSerFile(signMap, regressionFile);
        System.out.println();
        in.close();
        System.out.println("Done.");
    }
}

