/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkVertexInputAttributeDescription
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATION;
    public static final int BINDING;
    public static final int FORMAT;
    public static final int OFFSET;

    VkVertexInputAttributeDescription(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkVertexInputAttributeDescription(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkVertexInputAttributeDescription.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int location() {
        return VkVertexInputAttributeDescription.nlocation(this.address());
    }

    public int binding() {
        return VkVertexInputAttributeDescription.nbinding(this.address());
    }

    public int format() {
        return VkVertexInputAttributeDescription.nformat(this.address());
    }

    public int offset() {
        return VkVertexInputAttributeDescription.noffset(this.address());
    }

    public VkVertexInputAttributeDescription location(int value) {
        VkVertexInputAttributeDescription.nlocation(this.address(), value);
        return this;
    }

    public VkVertexInputAttributeDescription binding(int value) {
        VkVertexInputAttributeDescription.nbinding(this.address(), value);
        return this;
    }

    public VkVertexInputAttributeDescription format(int value) {
        VkVertexInputAttributeDescription.nformat(this.address(), value);
        return this;
    }

    public VkVertexInputAttributeDescription offset(int value) {
        VkVertexInputAttributeDescription.noffset(this.address(), value);
        return this;
    }

    public VkVertexInputAttributeDescription set(int location, int binding, int format, int offset) {
        this.location(location);
        this.binding(binding);
        this.format(format);
        this.offset(offset);
        return this;
    }

    public VkVertexInputAttributeDescription nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkVertexInputAttributeDescription set(VkVertexInputAttributeDescription src) {
        return this.nset(src.address());
    }

    public static VkVertexInputAttributeDescription malloc() {
        return VkVertexInputAttributeDescription.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkVertexInputAttributeDescription calloc() {
        return VkVertexInputAttributeDescription.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkVertexInputAttributeDescription create() {
        return new VkVertexInputAttributeDescription(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkVertexInputAttributeDescription create(long address) {
        return address == 0L ? null : new VkVertexInputAttributeDescription(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkVertexInputAttributeDescription.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVertexInputAttributeDescription.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkVertexInputAttributeDescription mallocStack() {
        return VkVertexInputAttributeDescription.mallocStack(MemoryStack.stackGet());
    }

    public static VkVertexInputAttributeDescription callocStack() {
        return VkVertexInputAttributeDescription.callocStack(MemoryStack.stackGet());
    }

    public static VkVertexInputAttributeDescription mallocStack(MemoryStack stack) {
        return VkVertexInputAttributeDescription.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVertexInputAttributeDescription callocStack(MemoryStack stack) {
        return VkVertexInputAttributeDescription.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkVertexInputAttributeDescription.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkVertexInputAttributeDescription.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkVertexInputAttributeDescription.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkVertexInputAttributeDescription.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlocation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LOCATION);
    }

    public static int nbinding(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDING);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OFFSET);
    }

    public static void nlocation(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LOCATION, value);
    }

    public static void nbinding(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDING, value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OFFSET, value);
    }

    static {
        Struct.Layout layout = VkVertexInputAttributeDescription.__struct(VkVertexInputAttributeDescription.__member(4), VkVertexInputAttributeDescription.__member(4), VkVertexInputAttributeDescription.__member(4), VkVertexInputAttributeDescription.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATION = layout.offsetof(0);
        BINDING = layout.offsetof(1);
        FORMAT = layout.offsetof(2);
        OFFSET = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<VkVertexInputAttributeDescription, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkVertexInputAttributeDescription newInstance(long address) {
            return new VkVertexInputAttributeDescription(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int location() {
            return VkVertexInputAttributeDescription.nlocation(this.address());
        }

        public int binding() {
            return VkVertexInputAttributeDescription.nbinding(this.address());
        }

        public int format() {
            return VkVertexInputAttributeDescription.nformat(this.address());
        }

        public int offset() {
            return VkVertexInputAttributeDescription.noffset(this.address());
        }

        public Buffer location(int value) {
            VkVertexInputAttributeDescription.nlocation(this.address(), value);
            return this;
        }

        public Buffer binding(int value) {
            VkVertexInputAttributeDescription.nbinding(this.address(), value);
            return this;
        }

        public Buffer format(int value) {
            VkVertexInputAttributeDescription.nformat(this.address(), value);
            return this;
        }

        public Buffer offset(int value) {
            VkVertexInputAttributeDescription.noffset(this.address(), value);
            return this;
        }
    }
}

