/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkSwapchainCreateInfoKHR
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SURFACE;
    public static final int MINIMAGECOUNT;
    public static final int IMAGEFORMAT;
    public static final int IMAGECOLORSPACE;
    public static final int IMAGEEXTENT;
    public static final int IMAGEARRAYLAYERS;
    public static final int IMAGEUSAGE;
    public static final int IMAGESHARINGMODE;
    public static final int QUEUEFAMILYINDEXCOUNT;
    public static final int PQUEUEFAMILYINDICES;
    public static final int PRETRANSFORM;
    public static final int COMPOSITEALPHA;
    public static final int PRESENTMODE;
    public static final int CLIPPED;
    public static final int OLDSWAPCHAIN;

    VkSwapchainCreateInfoKHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkSwapchainCreateInfoKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkSwapchainCreateInfoKHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkSwapchainCreateInfoKHR.nsType(this.address());
    }

    public long pNext() {
        return VkSwapchainCreateInfoKHR.npNext(this.address());
    }

    public int flags() {
        return VkSwapchainCreateInfoKHR.nflags(this.address());
    }

    public long surface() {
        return VkSwapchainCreateInfoKHR.nsurface(this.address());
    }

    public int minImageCount() {
        return VkSwapchainCreateInfoKHR.nminImageCount(this.address());
    }

    public int imageFormat() {
        return VkSwapchainCreateInfoKHR.nimageFormat(this.address());
    }

    public int imageColorSpace() {
        return VkSwapchainCreateInfoKHR.nimageColorSpace(this.address());
    }

    public VkExtent2D imageExtent() {
        return VkSwapchainCreateInfoKHR.nimageExtent(this.address());
    }

    public int imageArrayLayers() {
        return VkSwapchainCreateInfoKHR.nimageArrayLayers(this.address());
    }

    public int imageUsage() {
        return VkSwapchainCreateInfoKHR.nimageUsage(this.address());
    }

    public int imageSharingMode() {
        return VkSwapchainCreateInfoKHR.nimageSharingMode(this.address());
    }

    public int queueFamilyIndexCount() {
        return VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(this.address());
    }

    public IntBuffer pQueueFamilyIndices() {
        return VkSwapchainCreateInfoKHR.npQueueFamilyIndices(this.address());
    }

    public int preTransform() {
        return VkSwapchainCreateInfoKHR.npreTransform(this.address());
    }

    public int compositeAlpha() {
        return VkSwapchainCreateInfoKHR.ncompositeAlpha(this.address());
    }

    public int presentMode() {
        return VkSwapchainCreateInfoKHR.npresentMode(this.address());
    }

    public int clipped() {
        return VkSwapchainCreateInfoKHR.nclipped(this.address());
    }

    public long oldSwapchain() {
        return VkSwapchainCreateInfoKHR.noldSwapchain(this.address());
    }

    public VkSwapchainCreateInfoKHR sType(int value) {
        VkSwapchainCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR pNext(long value) {
        VkSwapchainCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR flags(int value) {
        VkSwapchainCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR surface(long value) {
        VkSwapchainCreateInfoKHR.nsurface(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR minImageCount(int value) {
        VkSwapchainCreateInfoKHR.nminImageCount(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageFormat(int value) {
        VkSwapchainCreateInfoKHR.nimageFormat(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageColorSpace(int value) {
        VkSwapchainCreateInfoKHR.nimageColorSpace(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageExtent(VkExtent2D value) {
        VkSwapchainCreateInfoKHR.nimageExtent(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageArrayLayers(int value) {
        VkSwapchainCreateInfoKHR.nimageArrayLayers(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageUsage(int value) {
        VkSwapchainCreateInfoKHR.nimageUsage(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR imageSharingMode(int value) {
        VkSwapchainCreateInfoKHR.nimageSharingMode(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR pQueueFamilyIndices(IntBuffer value) {
        VkSwapchainCreateInfoKHR.npQueueFamilyIndices(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR preTransform(int value) {
        VkSwapchainCreateInfoKHR.npreTransform(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR compositeAlpha(int value) {
        VkSwapchainCreateInfoKHR.ncompositeAlpha(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR presentMode(int value) {
        VkSwapchainCreateInfoKHR.npresentMode(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR clipped(int value) {
        VkSwapchainCreateInfoKHR.nclipped(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR oldSwapchain(long value) {
        VkSwapchainCreateInfoKHR.noldSwapchain(this.address(), value);
        return this;
    }

    public VkSwapchainCreateInfoKHR set(int sType, long pNext, int flags, long surface, int minImageCount, int imageFormat, int imageColorSpace, VkExtent2D imageExtent, int imageArrayLayers, int imageUsage, int imageSharingMode, IntBuffer pQueueFamilyIndices, int preTransform, int compositeAlpha, int presentMode, int clipped, long oldSwapchain) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.surface(surface);
        this.minImageCount(minImageCount);
        this.imageFormat(imageFormat);
        this.imageColorSpace(imageColorSpace);
        this.imageExtent(imageExtent);
        this.imageArrayLayers(imageArrayLayers);
        this.imageUsage(imageUsage);
        this.imageSharingMode(imageSharingMode);
        this.pQueueFamilyIndices(pQueueFamilyIndices);
        this.preTransform(preTransform);
        this.compositeAlpha(compositeAlpha);
        this.presentMode(presentMode);
        this.clipped(clipped);
        this.oldSwapchain(oldSwapchain);
        return this;
    }

    public VkSwapchainCreateInfoKHR nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkSwapchainCreateInfoKHR set(VkSwapchainCreateInfoKHR src) {
        return this.nset(src.address());
    }

    public static VkSwapchainCreateInfoKHR malloc() {
        return VkSwapchainCreateInfoKHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkSwapchainCreateInfoKHR calloc() {
        return VkSwapchainCreateInfoKHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkSwapchainCreateInfoKHR create() {
        return new VkSwapchainCreateInfoKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkSwapchainCreateInfoKHR create(long address) {
        return address == 0L ? null : new VkSwapchainCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkSwapchainCreateInfoKHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSwapchainCreateInfoKHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkSwapchainCreateInfoKHR mallocStack() {
        return VkSwapchainCreateInfoKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkSwapchainCreateInfoKHR callocStack() {
        return VkSwapchainCreateInfoKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkSwapchainCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkSwapchainCreateInfoKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSwapchainCreateInfoKHR callocStack(MemoryStack stack) {
        return VkSwapchainCreateInfoKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkSwapchainCreateInfoKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkSwapchainCreateInfoKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSwapchainCreateInfoKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSwapchainCreateInfoKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nsurface(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SURFACE);
    }

    public static int nminImageCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINIMAGECOUNT);
    }

    public static int nimageFormat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGEFORMAT);
    }

    public static int nimageColorSpace(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGECOLORSPACE);
    }

    public static VkExtent2D nimageExtent(long struct) {
        return VkExtent2D.create(struct + (long)IMAGEEXTENT);
    }

    public static int nimageArrayLayers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGEARRAYLAYERS);
    }

    public static int nimageUsage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGEUSAGE);
    }

    public static int nimageSharingMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGESHARINGMODE);
    }

    public static int nqueueFamilyIndexCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)QUEUEFAMILYINDEXCOUNT);
    }

    public static IntBuffer npQueueFamilyIndices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)PQUEUEFAMILYINDICES), VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(struct));
    }

    public static int npreTransform(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PRETRANSFORM);
    }

    public static int ncompositeAlpha(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COMPOSITEALPHA);
    }

    public static int npresentMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PRESENTMODE);
    }

    public static int nclipped(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CLIPPED);
    }

    public static long noldSwapchain(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OLDSWAPCHAIN);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nsurface(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SURFACE, value);
    }

    public static void nminImageCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MINIMAGECOUNT, value);
    }

    public static void nimageFormat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGEFORMAT, value);
    }

    public static void nimageColorSpace(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGECOLORSPACE, value);
    }

    public static void nimageExtent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGEEXTENT, VkExtent2D.SIZEOF);
    }

    public static void nimageArrayLayers(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGEARRAYLAYERS, value);
    }

    public static void nimageUsage(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGEUSAGE, value);
    }

    public static void nimageSharingMode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)IMAGESHARINGMODE, value);
    }

    public static void nqueueFamilyIndexCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)QUEUEFAMILYINDEXCOUNT, value);
    }

    public static void npQueueFamilyIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PQUEUEFAMILYINDICES, MemoryUtil.memAddressSafe(value));
        VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(struct, value == null ? 0 : value.remaining());
    }

    public static void npreTransform(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PRETRANSFORM, value);
    }

    public static void ncompositeAlpha(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COMPOSITEALPHA, value);
    }

    public static void npresentMode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PRESENTMODE, value);
    }

    public static void nclipped(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CLIPPED, value);
    }

    public static void noldSwapchain(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OLDSWAPCHAIN, value);
    }

    public static void validate(long struct) {
        if (VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(struct) != 0) {
            Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PQUEUEFAMILYINDICES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkSwapchainCreateInfoKHR.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkSwapchainCreateInfoKHR.__struct(VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(POINTER_SIZE), VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(8), VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(POINTER_SIZE), VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(4), VkSwapchainCreateInfoKHR.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SURFACE = layout.offsetof(3);
        MINIMAGECOUNT = layout.offsetof(4);
        IMAGEFORMAT = layout.offsetof(5);
        IMAGECOLORSPACE = layout.offsetof(6);
        IMAGEEXTENT = layout.offsetof(7);
        IMAGEARRAYLAYERS = layout.offsetof(8);
        IMAGEUSAGE = layout.offsetof(9);
        IMAGESHARINGMODE = layout.offsetof(10);
        QUEUEFAMILYINDEXCOUNT = layout.offsetof(11);
        PQUEUEFAMILYINDICES = layout.offsetof(12);
        PRETRANSFORM = layout.offsetof(13);
        COMPOSITEALPHA = layout.offsetof(14);
        PRESENTMODE = layout.offsetof(15);
        CLIPPED = layout.offsetof(16);
        OLDSWAPCHAIN = layout.offsetof(17);
    }

    public static final class Buffer
    extends StructBuffer<VkSwapchainCreateInfoKHR, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkSwapchainCreateInfoKHR newInstance(long address) {
            return new VkSwapchainCreateInfoKHR(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkSwapchainCreateInfoKHR.nsType(this.address());
        }

        public long pNext() {
            return VkSwapchainCreateInfoKHR.npNext(this.address());
        }

        public int flags() {
            return VkSwapchainCreateInfoKHR.nflags(this.address());
        }

        public long surface() {
            return VkSwapchainCreateInfoKHR.nsurface(this.address());
        }

        public int minImageCount() {
            return VkSwapchainCreateInfoKHR.nminImageCount(this.address());
        }

        public int imageFormat() {
            return VkSwapchainCreateInfoKHR.nimageFormat(this.address());
        }

        public int imageColorSpace() {
            return VkSwapchainCreateInfoKHR.nimageColorSpace(this.address());
        }

        public VkExtent2D imageExtent() {
            return VkSwapchainCreateInfoKHR.nimageExtent(this.address());
        }

        public int imageArrayLayers() {
            return VkSwapchainCreateInfoKHR.nimageArrayLayers(this.address());
        }

        public int imageUsage() {
            return VkSwapchainCreateInfoKHR.nimageUsage(this.address());
        }

        public int imageSharingMode() {
            return VkSwapchainCreateInfoKHR.nimageSharingMode(this.address());
        }

        public int queueFamilyIndexCount() {
            return VkSwapchainCreateInfoKHR.nqueueFamilyIndexCount(this.address());
        }

        public IntBuffer pQueueFamilyIndices() {
            return VkSwapchainCreateInfoKHR.npQueueFamilyIndices(this.address());
        }

        public int preTransform() {
            return VkSwapchainCreateInfoKHR.npreTransform(this.address());
        }

        public int compositeAlpha() {
            return VkSwapchainCreateInfoKHR.ncompositeAlpha(this.address());
        }

        public int presentMode() {
            return VkSwapchainCreateInfoKHR.npresentMode(this.address());
        }

        public int clipped() {
            return VkSwapchainCreateInfoKHR.nclipped(this.address());
        }

        public long oldSwapchain() {
            return VkSwapchainCreateInfoKHR.noldSwapchain(this.address());
        }

        public Buffer sType(int value) {
            VkSwapchainCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkSwapchainCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkSwapchainCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer surface(long value) {
            VkSwapchainCreateInfoKHR.nsurface(this.address(), value);
            return this;
        }

        public Buffer minImageCount(int value) {
            VkSwapchainCreateInfoKHR.nminImageCount(this.address(), value);
            return this;
        }

        public Buffer imageFormat(int value) {
            VkSwapchainCreateInfoKHR.nimageFormat(this.address(), value);
            return this;
        }

        public Buffer imageColorSpace(int value) {
            VkSwapchainCreateInfoKHR.nimageColorSpace(this.address(), value);
            return this;
        }

        public Buffer imageExtent(VkExtent2D value) {
            VkSwapchainCreateInfoKHR.nimageExtent(this.address(), value);
            return this;
        }

        public Buffer imageArrayLayers(int value) {
            VkSwapchainCreateInfoKHR.nimageArrayLayers(this.address(), value);
            return this;
        }

        public Buffer imageUsage(int value) {
            VkSwapchainCreateInfoKHR.nimageUsage(this.address(), value);
            return this;
        }

        public Buffer imageSharingMode(int value) {
            VkSwapchainCreateInfoKHR.nimageSharingMode(this.address(), value);
            return this;
        }

        public Buffer pQueueFamilyIndices(IntBuffer value) {
            VkSwapchainCreateInfoKHR.npQueueFamilyIndices(this.address(), value);
            return this;
        }

        public Buffer preTransform(int value) {
            VkSwapchainCreateInfoKHR.npreTransform(this.address(), value);
            return this;
        }

        public Buffer compositeAlpha(int value) {
            VkSwapchainCreateInfoKHR.ncompositeAlpha(this.address(), value);
            return this;
        }

        public Buffer presentMode(int value) {
            VkSwapchainCreateInfoKHR.npresentMode(this.address(), value);
            return this;
        }

        public Buffer clipped(int value) {
            VkSwapchainCreateInfoKHR.nclipped(this.address(), value);
            return this;
        }

        public Buffer oldSwapchain(long value) {
            VkSwapchainCreateInfoKHR.noldSwapchain(this.address(), value);
            return this;
        }
    }
}

