/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.macosx.CoreFoundation;
import org.lwjgl.system.macosx.MacOSXLibrary;

public class MacOSXLibraryBundle
extends MacOSXLibrary {
    public MacOSXLibraryBundle(String name) {
        super(MacOSXLibraryBundle.createBundle(name), name);
    }

    /*
     * Loose catch block
     */
    private static long createBundle(String path) {
        long filePath = 0L;
        long url = 0L;
        try {
            try (MemoryStack stack = MemoryStack.stackPush();){
                filePath = MacOSXLibraryBundle.CString2CFString(stack.UTF8(path), 0x8000100);
                url = Checks.checkPointer(CoreFoundation.CFURLCreateWithFileSystemPath(0L, filePath, 0L, true));
                long bundleRef = CoreFoundation.CFBundleCreate(0L, url);
                if (bundleRef == 0L) {
                    throw new RuntimeException("Failed to dynamically load bundle: " + path);
                }
                APIUtil.apiLog("Loaded native library bundle: " + path);
                long l = bundleRef;
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (url != 0L) {
                CoreFoundation.CFRelease(url);
            }
            if (filePath != 0L) {
                CoreFoundation.CFRelease(filePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFunctionAddress(ByteBuffer functionName) {
        long nameRef = MacOSXLibraryBundle.CString2CFString(functionName, 1536);
        try {
            long l = CoreFoundation.CFBundleGetFunctionPointerForName(this.address(), nameRef);
            return l;
        }
        finally {
            CoreFoundation.CFRelease(nameRef);
        }
    }

    private static long CString2CFString(ByteBuffer name, int encoding) {
        return Checks.checkPointer(CoreFoundation.CFStringCreateWithCStringNoCopy(0L, name, encoding, CoreFoundation.kCFAllocatorNull));
    }

    @Override
    public void free() {
        CoreFoundation.CFRelease(this.address());
    }
}

