/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class DynamicLinkLoader {
    public static final int RTLD_LAZY = 1;
    public static final int RTLD_NOW = 2;
    public static final int RTLD_LOCAL = 4;
    public static final int RTLD_GLOBAL = 8;
    public static final long RTLD_NEXT = -1L;
    public static final long RTLD_DEFAULT = -2L;
    public static final long RTLD_SELF = -3L;
    public static final long RTLD_MAIN_ONLY = -5L;

    protected DynamicLinkLoader() {
        throw new UnsupportedOperationException();
    }

    public static native long ndlopen(long var0, int var2);

    public static long dlopen(ByteBuffer path, int mode) {
        if (Checks.CHECKS && path != null) {
            Checks.checkNT1(path);
        }
        return DynamicLinkLoader.ndlopen(MemoryUtil.memAddressSafe(path), mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long dlopen(CharSequence path, int mode) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pathEncoded = path == null ? null : stack.ASCII(path);
            long l = DynamicLinkLoader.ndlopen(MemoryUtil.memAddressSafe(pathEncoded), mode);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native long ndlerror();

    public static String dlerror() {
        long __result = DynamicLinkLoader.ndlerror();
        return MemoryUtil.memASCII(__result);
    }

    public static native long ndlsym(long var0, long var2);

    public static long dlsym(long handle, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkPointer(handle);
            Checks.checkNT1(name);
        }
        return DynamicLinkLoader.ndlsym(handle, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long dlsym(long handle, CharSequence name) {
        if (Checks.CHECKS) {
            Checks.checkPointer(handle);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            long l = DynamicLinkLoader.ndlsym(handle, MemoryUtil.memAddress(nameEncoded));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int ndlclose(long var0);

    public static int dlclose(long handle) {
        if (Checks.CHECKS) {
            Checks.checkPointer(handle);
        }
        return DynamicLinkLoader.ndlclose(handle);
    }

    static {
        Library.initialize();
    }
}

