/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jemalloc;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.jemalloc.MallocMessageCallbackI;

public class JEmalloc {
    private static final SharedLibrary JEMALLOC = Library.loadNative(Configuration.JEMALLOC_LIBRARY_NAME.get(System.getProperty("os.arch").contains("64") ? "jemalloc" : "jemalloc32"));

    protected JEmalloc() {
        throw new UnsupportedOperationException();
    }

    public static SharedLibrary getLibrary() {
        return JEMALLOC;
    }

    public static PointerBuffer je_malloc_message() {
        long __result = Functions.malloc_message;
        return MemoryUtil.memPointerBuffer(__result, 1);
    }

    public static long nje_malloc(long size) {
        long __functionAddress = Functions.malloc;
        return JNI.invokePP(__functionAddress, size);
    }

    public static ByteBuffer je_malloc(long size) {
        long __result = JEmalloc.nje_malloc(size);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static long nje_calloc(long num, long size) {
        long __functionAddress = Functions.calloc;
        return JNI.invokePPP(__functionAddress, num, size);
    }

    public static ByteBuffer je_calloc(long num, long size) {
        long __result = JEmalloc.nje_calloc(num, size);
        return MemoryUtil.memByteBuffer(__result, (int)num * (int)size);
    }

    public static int nje_posix_memalign(long memptr, long alignment, long size) {
        long __functionAddress = Functions.posix_memalign;
        return JNI.invokePPPI(__functionAddress, memptr, alignment, size);
    }

    public static int je_posix_memalign(PointerBuffer memptr, long alignment, long size) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(memptr, 1);
        }
        return JEmalloc.nje_posix_memalign(MemoryUtil.memAddress(memptr), alignment, size);
    }

    public static long nje_aligned_alloc(long alignment, long size) {
        long __functionAddress = Functions.aligned_alloc;
        return JNI.invokePPP(__functionAddress, alignment, size);
    }

    public static ByteBuffer je_aligned_alloc(long alignment, long size) {
        long __result = JEmalloc.nje_aligned_alloc(alignment, size);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static long nje_realloc(long ptr, long size) {
        long __functionAddress = Functions.realloc;
        return JNI.invokePPP(__functionAddress, ptr, size);
    }

    public static ByteBuffer je_realloc(ByteBuffer ptr, long size) {
        long __result = JEmalloc.nje_realloc(MemoryUtil.memAddressSafe(ptr), size);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static void nje_free(long ptr) {
        long __functionAddress = Functions.free;
        JNI.invokePV(__functionAddress, ptr);
    }

    public static void je_free(ByteBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void je_free(ShortBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void je_free(IntBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void je_free(LongBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void je_free(FloatBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void je_free(DoubleBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static void je_free(PointerBuffer ptr) {
        JEmalloc.nje_free(MemoryUtil.memAddressSafe(ptr));
    }

    public static long nje_mallocx(long size, int flags) {
        long __functionAddress = Functions.mallocx;
        return JNI.invokePP(__functionAddress, size, flags);
    }

    public static ByteBuffer je_mallocx(long size, int flags) {
        long __result = JEmalloc.nje_mallocx(size, flags);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static long nje_rallocx(long ptr, long size, int flags) {
        long __functionAddress = Functions.rallocx;
        return JNI.invokePPP(__functionAddress, ptr, size, flags);
    }

    public static ByteBuffer je_rallocx(ByteBuffer ptr, long size, int flags) {
        long __result = JEmalloc.nje_rallocx(MemoryUtil.memAddressSafe(ptr), size, flags);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static long nje_xallocx(long ptr, long size, long extra, int flags) {
        long __functionAddress = Functions.xallocx;
        return JNI.invokePPPP(__functionAddress, ptr, size, extra, flags);
    }

    public static long je_xallocx(ByteBuffer ptr, long size, long extra, int flags) {
        return JEmalloc.nje_xallocx(MemoryUtil.memAddressSafe(ptr), size, extra, flags);
    }

    public static long nje_sallocx(long ptr, int flags) {
        long __functionAddress = Functions.sallocx;
        return JNI.invokePP(__functionAddress, ptr, flags);
    }

    public static long je_sallocx(ByteBuffer ptr, int flags) {
        return JEmalloc.nje_sallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void nje_dallocx(long ptr, int flags) {
        long __functionAddress = Functions.dallocx;
        JNI.invokePV(__functionAddress, ptr, flags);
    }

    public static void je_dallocx(ByteBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void je_dallocx(ShortBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void je_dallocx(IntBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void je_dallocx(LongBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void je_dallocx(FloatBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void je_dallocx(DoubleBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void je_dallocx(PointerBuffer ptr, int flags) {
        JEmalloc.nje_dallocx(MemoryUtil.memAddress(ptr), flags);
    }

    public static void nje_sdallocx(long ptr, long size, int flags) {
        long __functionAddress = Functions.sdallocx;
        JNI.invokePPV(__functionAddress, ptr, size, flags);
    }

    public static void je_sdallocx(ByteBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining(), flags);
    }

    public static void je_sdallocx(ShortBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining() << 1, flags);
    }

    public static void je_sdallocx(IntBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining() << 2, flags);
    }

    public static void je_sdallocx(LongBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining() << 3, flags);
    }

    public static void je_sdallocx(FloatBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining() << 2, flags);
    }

    public static void je_sdallocx(DoubleBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining() << 3, flags);
    }

    public static void je_sdallocx(PointerBuffer ptr, int flags) {
        JEmalloc.nje_sdallocx(MemoryUtil.memAddress(ptr), ptr.remaining() << Pointer.POINTER_SHIFT, flags);
    }

    public static long nje_nallocx(long size, int flags) {
        long __functionAddress = Functions.nallocx;
        return JNI.invokePP(__functionAddress, size, flags);
    }

    public static ByteBuffer je_nallocx(long size, int flags) {
        long __result = JEmalloc.nje_nallocx(size, flags);
        return MemoryUtil.memByteBuffer(__result, (int)size);
    }

    public static int nje_mallctl(long name, long oldp, long oldlenp, long newp, long newlen) {
        long __functionAddress = Functions.mallctl;
        return JNI.invokePPPPPI(__functionAddress, name, oldp, oldlenp, newp, newlen);
    }

    public static int je_mallctl(ByteBuffer name, ByteBuffer oldp, PointerBuffer oldlenp, ByteBuffer newp) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            if (oldlenp != null) {
                Checks.checkBuffer(oldlenp, 1);
            }
        }
        return JEmalloc.nje_mallctl(MemoryUtil.memAddress(name), MemoryUtil.memAddressSafe(oldp), MemoryUtil.memAddressSafe(oldlenp), MemoryUtil.memAddressSafe(newp), newp == null ? 0 : newp.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int je_mallctl(CharSequence name, ByteBuffer oldp, PointerBuffer oldlenp, ByteBuffer newp) {
        if (Checks.CHECKS && oldlenp != null) {
            Checks.checkBuffer(oldlenp, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = JEmalloc.nje_mallctl(MemoryUtil.memAddress(nameEncoded), MemoryUtil.memAddressSafe(oldp), MemoryUtil.memAddressSafe(oldlenp), MemoryUtil.memAddressSafe(newp), newp == null ? 0 : newp.remaining());
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nje_mallctlnametomib(long name, long mibp, long miblenp) {
        long __functionAddress = Functions.mallctlnametomib;
        return JNI.invokePPPI(__functionAddress, name, mibp, miblenp);
    }

    public static int je_mallctlnametomib(ByteBuffer name, PointerBuffer mibp, PointerBuffer miblenp) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkBuffer(miblenp, 1);
            Checks.checkBuffer(mibp, miblenp.get(miblenp.position()));
        }
        return JEmalloc.nje_mallctlnametomib(MemoryUtil.memAddress(name), MemoryUtil.memAddress(mibp), MemoryUtil.memAddress(miblenp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int je_mallctlnametomib(CharSequence name, PointerBuffer mibp, PointerBuffer miblenp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(miblenp, 1);
            Checks.checkBuffer(mibp, miblenp.get(miblenp.position()));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = JEmalloc.nje_mallctlnametomib(MemoryUtil.memAddress(nameEncoded), MemoryUtil.memAddress(mibp), MemoryUtil.memAddress(miblenp));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nje_mallctlbymib(long mib, long miblen, long oldp, long oldlenp, long newp, long newlen) {
        long __functionAddress = Functions.mallctlbymib;
        return JNI.invokePPPPPPI(__functionAddress, mib, miblen, oldp, oldlenp, newp, newlen);
    }

    public static int je_mallctlbymib(PointerBuffer mib, ByteBuffer oldp, PointerBuffer oldlenp, ByteBuffer newp) {
        if (Checks.CHECKS && oldlenp != null) {
            Checks.checkBuffer(oldlenp, 1);
        }
        return JEmalloc.nje_mallctlbymib(MemoryUtil.memAddress(mib), mib.remaining(), MemoryUtil.memAddressSafe(oldp), MemoryUtil.memAddressSafe(oldlenp), MemoryUtil.memAddressSafe(newp), newp == null ? 0 : newp.remaining());
    }

    public static void nje_malloc_stats_print(long write_cb, long je_cbopaque, long opts) {
        long __functionAddress = Functions.malloc_stats_print;
        JNI.invokePPPV(__functionAddress, write_cb, je_cbopaque, opts);
    }

    public static void je_malloc_stats_print(MallocMessageCallbackI write_cb, ByteBuffer je_cbopaque, ByteBuffer opts) {
        if (Checks.CHECKS && opts != null) {
            Checks.checkNT1(opts);
        }
        JEmalloc.nje_malloc_stats_print(write_cb == null ? 0L : write_cb.address(), MemoryUtil.memAddressSafe(je_cbopaque), MemoryUtil.memAddressSafe(opts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void je_malloc_stats_print(MallocMessageCallbackI write_cb, ByteBuffer je_cbopaque, CharSequence opts) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer optsEncoded = opts == null ? null : stack.ASCII(opts);
            JEmalloc.nje_malloc_stats_print(write_cb == null ? 0L : write_cb.address(), MemoryUtil.memAddressSafe(je_cbopaque), MemoryUtil.memAddressSafe(optsEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nje_malloc_usable_size(long ptr) {
        long __functionAddress = Functions.malloc_usable_size;
        return JNI.invokePP(__functionAddress, ptr);
    }

    public static long je_malloc_usable_size(ByteBuffer ptr) {
        return JEmalloc.nje_malloc_usable_size(MemoryUtil.memAddress(ptr));
    }

    public static void je_free(short[] ptr) {
        long __functionAddress = Functions.free;
        JNI.invokePV(__functionAddress, ptr);
    }

    public static void je_free(int[] ptr) {
        long __functionAddress = Functions.free;
        JNI.invokePV(__functionAddress, ptr);
    }

    public static void je_free(long[] ptr) {
        long __functionAddress = Functions.free;
        JNI.invokePV(__functionAddress, ptr);
    }

    public static void je_free(float[] ptr) {
        long __functionAddress = Functions.free;
        JNI.invokePV(__functionAddress, ptr);
    }

    public static void je_free(double[] ptr) {
        long __functionAddress = Functions.free;
        JNI.invokePV(__functionAddress, ptr);
    }

    public static void je_dallocx(short[] ptr, int flags) {
        long __functionAddress = Functions.dallocx;
        JNI.invokePV(__functionAddress, ptr, flags);
    }

    public static void je_dallocx(int[] ptr, int flags) {
        long __functionAddress = Functions.dallocx;
        JNI.invokePV(__functionAddress, ptr, flags);
    }

    public static void je_dallocx(long[] ptr, int flags) {
        long __functionAddress = Functions.dallocx;
        JNI.invokePV(__functionAddress, ptr, flags);
    }

    public static void je_dallocx(float[] ptr, int flags) {
        long __functionAddress = Functions.dallocx;
        JNI.invokePV(__functionAddress, ptr, flags);
    }

    public static void je_dallocx(double[] ptr, int flags) {
        long __functionAddress = Functions.dallocx;
        JNI.invokePV(__functionAddress, ptr, flags);
    }

    public static void je_sdallocx(short[] ptr, int flags) {
        long __functionAddress = Functions.sdallocx;
        JNI.invokePPV(__functionAddress, ptr, (long)(ptr.length << 1), flags);
    }

    public static void je_sdallocx(int[] ptr, int flags) {
        long __functionAddress = Functions.sdallocx;
        JNI.invokePPV(__functionAddress, ptr, (long)(ptr.length << 2), flags);
    }

    public static void je_sdallocx(long[] ptr, int flags) {
        long __functionAddress = Functions.sdallocx;
        JNI.invokePPV(__functionAddress, ptr, (long)(ptr.length << 3), flags);
    }

    public static void je_sdallocx(float[] ptr, int flags) {
        long __functionAddress = Functions.sdallocx;
        JNI.invokePPV(__functionAddress, ptr, (long)(ptr.length << 2), flags);
    }

    public static void je_sdallocx(double[] ptr, int flags) {
        long __functionAddress = Functions.sdallocx;
        JNI.invokePPV(__functionAddress, ptr, (long)(ptr.length << 3), flags);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return JEMALLOC;
    }

    public static final class Functions {
        public static final long malloc_message = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_malloc_message");
        public static final long malloc = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_malloc");
        public static final long calloc = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_calloc");
        public static final long posix_memalign = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_posix_memalign");
        public static final long aligned_alloc = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_aligned_alloc");
        public static final long realloc = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_realloc");
        public static final long free = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_free");
        public static final long mallocx = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_mallocx");
        public static final long rallocx = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_rallocx");
        public static final long xallocx = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_xallocx");
        public static final long sallocx = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_sallocx");
        public static final long dallocx = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_dallocx");
        public static final long sdallocx = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_sdallocx");
        public static final long nallocx = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_nallocx");
        public static final long mallctl = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_mallctl");
        public static final long mallctlnametomib = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_mallctlnametomib");
        public static final long mallctlbymib = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_mallctlbymib");
        public static final long malloc_stats_print = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_malloc_stats_print");
        public static final long malloc_usable_size = APIUtil.apiGetFunctionAddress(JEmalloc.access$000(), "je_malloc_usable_size");

        private Functions() {
        }
    }
}

