/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class QCOMExtendedGet2 {
    protected QCOMExtendedGet2() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glExtGetShadersQCOM, caps.glExtGetProgramsQCOM, caps.glExtIsProgramBinaryQCOM, caps.glExtGetProgramBinarySourceQCOM);
    }

    public static void nglExtGetShadersQCOM(long shaders, int maxShaders, long numShaders) {
        long __functionAddress = GLES.getCapabilities().glExtGetShadersQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, shaders, maxShaders, numShaders);
    }

    public static void glExtGetShadersQCOM(IntBuffer shaders, IntBuffer numShaders) {
        if (Checks.CHECKS && numShaders != null) {
            Checks.checkBuffer((Buffer)numShaders, 1);
        }
        QCOMExtendedGet2.nglExtGetShadersQCOM(MemoryUtil.memAddressSafe(shaders), shaders == null ? 0 : shaders.remaining(), MemoryUtil.memAddressSafe(numShaders));
    }

    public static void nglExtGetProgramsQCOM(long programs, int maxPrograms, long numPrograms) {
        long __functionAddress = GLES.getCapabilities().glExtGetProgramsQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, programs, maxPrograms, numPrograms);
    }

    public static void glExtGetProgramsQCOM(IntBuffer programs, IntBuffer numPrograms) {
        if (Checks.CHECKS && numPrograms != null) {
            Checks.checkBuffer((Buffer)numPrograms, 1);
        }
        QCOMExtendedGet2.nglExtGetProgramsQCOM(MemoryUtil.memAddressSafe(programs), programs == null ? 0 : programs.remaining(), MemoryUtil.memAddressSafe(numPrograms));
    }

    public static boolean glExtIsProgramBinaryQCOM(int program) {
        long __functionAddress = GLES.getCapabilities().glExtIsProgramBinaryQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, program);
    }

    public static void nglExtGetProgramBinarySourceQCOM(int program, int shadertype, long source, long length) {
        long __functionAddress = GLES.getCapabilities().glExtGetProgramBinarySourceQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, program, shadertype, source, length);
    }

    public static void glExtGetProgramBinarySourceQCOM(int program, int shadertype, ByteBuffer source, IntBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        QCOMExtendedGet2.nglExtGetProgramBinarySourceQCOM(program, shadertype, MemoryUtil.memAddressSafe(source), MemoryUtil.memAddressSafe(length));
    }

    public static void glExtGetShadersQCOM(int[] shaders, int[] numShaders) {
        long __functionAddress = GLES.getCapabilities().glExtGetShadersQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (numShaders != null) {
                Checks.checkBuffer(numShaders, 1);
            }
        }
        JNI.callPPV(__functionAddress, shaders, shaders == null ? 0 : shaders.length, numShaders);
    }

    public static void glExtGetProgramsQCOM(int[] programs, int[] numPrograms) {
        long __functionAddress = GLES.getCapabilities().glExtGetProgramsQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (numPrograms != null) {
                Checks.checkBuffer(numPrograms, 1);
            }
        }
        JNI.callPPV(__functionAddress, programs, programs == null ? 0 : programs.length, numPrograms);
    }

    public static void glExtGetProgramBinarySourceQCOM(int program, int shadertype, ByteBuffer source, int[] length) {
        long __functionAddress = GLES.getCapabilities().glExtGetProgramBinarySourceQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, program, shadertype, MemoryUtil.memAddressSafe(source), length);
    }
}

