/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class GLES20 {
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_STENCIL_BUFFER_BIT = 1024;
    public static final int GL_COLOR_BUFFER_BIT = 16384;
    public static final int GL_FALSE = 0;
    public static final int GL_TRUE = 1;
    public static final int GL_POINTS = 0;
    public static final int GL_LINES = 1;
    public static final int GL_LINE_LOOP = 2;
    public static final int GL_LINE_STRIP = 3;
    public static final int GL_TRIANGLES = 4;
    public static final int GL_TRIANGLE_STRIP = 5;
    public static final int GL_TRIANGLE_FAN = 6;
    public static final int GL_ZERO = 0;
    public static final int GL_ONE = 1;
    public static final int GL_SRC_COLOR = 768;
    public static final int GL_ONE_MINUS_SRC_COLOR = 769;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_DST_ALPHA = 772;
    public static final int GL_ONE_MINUS_DST_ALPHA = 773;
    public static final int GL_DST_COLOR = 774;
    public static final int GL_ONE_MINUS_DST_COLOR = 775;
    public static final int GL_SRC_ALPHA_SATURATE = 776;
    public static final int GL_FUNC_ADD = 32774;
    public static final int GL_BLEND_EQUATION = 32777;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;
    public static final int GL_FUNC_SUBTRACT = 32778;
    public static final int GL_FUNC_REVERSE_SUBTRACT = 32779;
    public static final int GL_BLEND_DST_RGB = 32968;
    public static final int GL_BLEND_SRC_RGB = 32969;
    public static final int GL_BLEND_DST_ALPHA = 32970;
    public static final int GL_BLEND_SRC_ALPHA = 32971;
    public static final int GL_CONSTANT_COLOR = 32769;
    public static final int GL_ONE_MINUS_CONSTANT_COLOR = 32770;
    public static final int GL_CONSTANT_ALPHA = 32771;
    public static final int GL_ONE_MINUS_CONSTANT_ALPHA = 32772;
    public static final int GL_BLEND_COLOR = 32773;
    public static final int GL_ARRAY_BUFFER = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public static final int GL_STREAM_DRAW = 35040;
    public static final int GL_STATIC_DRAW = 35044;
    public static final int GL_DYNAMIC_DRAW = 35048;
    public static final int GL_BUFFER_SIZE = 34660;
    public static final int GL_BUFFER_USAGE = 34661;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_FRONT = 1028;
    public static final int GL_BACK = 1029;
    public static final int GL_FRONT_AND_BACK = 1032;
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_CULL_FACE = 2884;
    public static final int GL_BLEND = 3042;
    public static final int GL_DITHER = 3024;
    public static final int GL_STENCIL_TEST = 2960;
    public static final int GL_DEPTH_TEST = 2929;
    public static final int GL_SCISSOR_TEST = 3089;
    public static final int GL_POLYGON_OFFSET_FILL = 32823;
    public static final int GL_SAMPLE_ALPHA_TO_COVERAGE = 32926;
    public static final int GL_SAMPLE_COVERAGE = 32928;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_INVALID_ENUM = 1280;
    public static final int GL_INVALID_VALUE = 1281;
    public static final int GL_INVALID_OPERATION = 1282;
    public static final int GL_OUT_OF_MEMORY = 1285;
    public static final int GL_CW = 2304;
    public static final int GL_CCW = 2305;
    public static final int GL_LINE_WIDTH = 2849;
    public static final int GL_ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int GL_ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int GL_CULL_FACE_MODE = 2885;
    public static final int GL_FRONT_FACE = 2886;
    public static final int GL_DEPTH_RANGE = 2928;
    public static final int GL_DEPTH_WRITEMASK = 2930;
    public static final int GL_DEPTH_CLEAR_VALUE = 2931;
    public static final int GL_DEPTH_FUNC = 2932;
    public static final int GL_STENCIL_CLEAR_VALUE = 2961;
    public static final int GL_STENCIL_FUNC = 2962;
    public static final int GL_STENCIL_FAIL = 2964;
    public static final int GL_STENCIL_PASS_DEPTH_FAIL = 2965;
    public static final int GL_STENCIL_PASS_DEPTH_PASS = 2966;
    public static final int GL_STENCIL_REF = 2967;
    public static final int GL_STENCIL_VALUE_MASK = 2963;
    public static final int GL_STENCIL_WRITEMASK = 2968;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;
    public static final int GL_VIEWPORT = 2978;
    public static final int GL_SCISSOR_BOX = 3088;
    public static final int GL_COLOR_CLEAR_VALUE = 3106;
    public static final int GL_COLOR_WRITEMASK = 3107;
    public static final int GL_UNPACK_ALIGNMENT = 3317;
    public static final int GL_PACK_ALIGNMENT = 3333;
    public static final int GL_MAX_TEXTURE_SIZE = 3379;
    public static final int GL_MAX_VIEWPORT_DIMS = 3386;
    public static final int GL_SUBPIXEL_BITS = 3408;
    public static final int GL_RED_BITS = 3410;
    public static final int GL_GREEN_BITS = 3411;
    public static final int GL_BLUE_BITS = 3412;
    public static final int GL_ALPHA_BITS = 3413;
    public static final int GL_DEPTH_BITS = 3414;
    public static final int GL_STENCIL_BITS = 3415;
    public static final int GL_POLYGON_OFFSET_UNITS = 10752;
    public static final int GL_POLYGON_OFFSET_FACTOR = 32824;
    public static final int GL_TEXTURE_BINDING_2D = 32873;
    public static final int GL_SAMPLE_BUFFERS = 32936;
    public static final int GL_SAMPLES = 32937;
    public static final int GL_SAMPLE_COVERAGE_VALUE = 32938;
    public static final int GL_SAMPLE_COVERAGE_INVERT = 32939;
    public static final int GL_NUM_COMPRESSED_TEXTURE_FORMATS = 34466;
    public static final int GL_COMPRESSED_TEXTURE_FORMATS = 34467;
    public static final int GL_DONT_CARE = 4352;
    public static final int GL_FASTEST = 4353;
    public static final int GL_NICEST = 4354;
    public static final int GL_GENERATE_MIPMAP_HINT = 33170;
    public static final int GL_BYTE = 5120;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_SHORT = 5122;
    public static final int GL_UNSIGNED_SHORT = 5123;
    public static final int GL_INT = 5124;
    public static final int GL_UNSIGNED_INT = 5125;
    public static final int GL_FLOAT = 5126;
    public static final int GL_FIXED = 5132;
    public static final int GL_DEPTH_COMPONENT = 6402;
    public static final int GL_ALPHA = 6406;
    public static final int GL_RGB = 6407;
    public static final int GL_RGBA = 6408;
    public static final int GL_LUMINANCE = 6409;
    public static final int GL_LUMINANCE_ALPHA = 6410;
    public static final int GL_UNSIGNED_SHORT_4_4_4_4 = 32819;
    public static final int GL_UNSIGNED_SHORT_5_5_5_1 = 32820;
    public static final int GL_UNSIGNED_SHORT_5_6_5 = 33635;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_NEVER = 512;
    public static final int GL_LESS = 513;
    public static final int GL_EQUAL = 514;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GREATER = 516;
    public static final int GL_NOTEQUAL = 517;
    public static final int GL_GEQUAL = 518;
    public static final int GL_ALWAYS = 519;
    public static final int GL_KEEP = 7680;
    public static final int GL_REPLACE = 7681;
    public static final int GL_INCR = 7682;
    public static final int GL_DECR = 7683;
    public static final int GL_INVERT = 5386;
    public static final int GL_INCR_WRAP = 34055;
    public static final int GL_DECR_WRAP = 34056;
    public static final int GL_VENDOR = 7936;
    public static final int GL_RENDERER = 7937;
    public static final int GL_VERSION = 7938;
    public static final int GL_EXTENSIONS = 7939;
    public static final int GL_NEAREST = 9728;
    public static final int GL_LINEAR = 9729;
    public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
    public static final int GL_LINEAR_MIPMAP_NEAREST = 9985;
    public static final int GL_NEAREST_MIPMAP_LINEAR = 9986;
    public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_TEXTURE = 5890;
    public static final int GL_TEXTURE_CUBE_MAP = 34067;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP = 34068;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
    public static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
    public static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
    public static final int GL_MAX_CUBE_MAP_TEXTURE_SIZE = 34076;
    public static final int GL_TEXTURE0 = 33984;
    public static final int GL_TEXTURE1 = 33985;
    public static final int GL_TEXTURE2 = 33986;
    public static final int GL_TEXTURE3 = 33987;
    public static final int GL_TEXTURE4 = 33988;
    public static final int GL_TEXTURE5 = 33989;
    public static final int GL_TEXTURE6 = 33990;
    public static final int GL_TEXTURE7 = 33991;
    public static final int GL_TEXTURE8 = 33992;
    public static final int GL_TEXTURE9 = 33993;
    public static final int GL_TEXTURE10 = 33994;
    public static final int GL_TEXTURE11 = 33995;
    public static final int GL_TEXTURE12 = 33996;
    public static final int GL_TEXTURE13 = 33997;
    public static final int GL_TEXTURE14 = 33998;
    public static final int GL_TEXTURE15 = 33999;
    public static final int GL_TEXTURE16 = 34000;
    public static final int GL_TEXTURE17 = 34001;
    public static final int GL_TEXTURE18 = 34002;
    public static final int GL_TEXTURE19 = 34003;
    public static final int GL_TEXTURE20 = 34004;
    public static final int GL_TEXTURE21 = 34005;
    public static final int GL_TEXTURE22 = 34006;
    public static final int GL_TEXTURE23 = 34007;
    public static final int GL_TEXTURE24 = 34008;
    public static final int GL_TEXTURE25 = 34009;
    public static final int GL_TEXTURE26 = 34010;
    public static final int GL_TEXTURE27 = 34011;
    public static final int GL_TEXTURE28 = 34012;
    public static final int GL_TEXTURE29 = 34013;
    public static final int GL_TEXTURE30 = 34014;
    public static final int GL_TEXTURE31 = 34015;
    public static final int GL_ACTIVE_TEXTURE = 34016;
    public static final int GL_REPEAT = 10497;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_MIRRORED_REPEAT = 33648;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_FRAMEBUFFER = 36160;
    public static final int GL_RENDERBUFFER = 36161;
    public static final int GL_RGBA4 = 32854;
    public static final int GL_RGB5_A1 = 32855;
    public static final int GL_RGB565 = 36194;
    public static final int GL_DEPTH_COMPONENT16 = 33189;
    public static final int GL_STENCIL_INDEX8 = 36168;
    public static final int GL_RENDERBUFFER_WIDTH = 36162;
    public static final int GL_RENDERBUFFER_HEIGHT = 36163;
    public static final int GL_RENDERBUFFER_INTERNAL_FORMAT = 36164;
    public static final int GL_RENDERBUFFER_RED_SIZE = 36176;
    public static final int GL_RENDERBUFFER_GREEN_SIZE = 36177;
    public static final int GL_RENDERBUFFER_BLUE_SIZE = 36178;
    public static final int GL_RENDERBUFFER_ALPHA_SIZE = 36179;
    public static final int GL_RENDERBUFFER_DEPTH_SIZE = 36180;
    public static final int GL_RENDERBUFFER_STENCIL_SIZE = 36181;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
    public static final int GL_COLOR_ATTACHMENT0 = 36064;
    public static final int GL_DEPTH_ATTACHMENT = 36096;
    public static final int GL_STENCIL_ATTACHMENT = 36128;
    public static final int GL_NONE = 0;
    public static final int GL_FRAMEBUFFER_COMPLETE = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int GL_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_RENDERBUFFER_BINDING = 36007;
    public static final int GL_MAX_RENDERBUFFER_SIZE = 34024;
    public static final int GL_INVALID_FRAMEBUFFER_OPERATION = 1286;

    protected GLES20() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glActiveTexture, caps.glAttachShader, caps.glBindAttribLocation, caps.glBindBuffer, caps.glBindFramebuffer, caps.glBindRenderbuffer, caps.glBindTexture, caps.glBlendColor, caps.glBlendEquation, caps.glBlendEquationSeparate, caps.glBlendFunc, caps.glBlendFuncSeparate, caps.glBufferData, caps.glBufferSubData, caps.glCheckFramebufferStatus, caps.glClear, caps.glClearColor, caps.glClearDepthf, caps.glClearStencil, caps.glColorMask, caps.glCompileShader, caps.glCompressedTexImage2D, caps.glCompressedTexSubImage2D, caps.glCopyTexImage2D, caps.glCopyTexSubImage2D, caps.glCreateProgram, caps.glCreateShader, caps.glCullFace, caps.glDeleteBuffers, caps.glDeleteFramebuffers, caps.glDeleteProgram, caps.glDeleteRenderbuffers, caps.glDeleteShader, caps.glDeleteTextures, caps.glDepthFunc, caps.glDepthMask, caps.glDepthRangef, caps.glDetachShader, caps.glDisable, caps.glDisableVertexAttribArray, caps.glDrawArrays, caps.glDrawElements, caps.glEnable, caps.glEnableVertexAttribArray, caps.glFinish, caps.glFlush, caps.glFramebufferRenderbuffer, caps.glFramebufferTexture2D, caps.glFrontFace, caps.glGenBuffers, caps.glGenerateMipmap, caps.glGenFramebuffers, caps.glGenRenderbuffers, caps.glGenTextures, caps.glGetActiveAttrib, caps.glGetActiveUniform, caps.glGetAttachedShaders, caps.glGetAttribLocation, caps.glGetBooleanv, caps.glGetBufferParameteriv, caps.glGetError, caps.glGetFloatv, caps.glGetFramebufferAttachmentParameteriv, caps.glGetIntegerv, caps.glGetProgramiv, caps.glGetProgramInfoLog, caps.glGetRenderbufferParameteriv, caps.glGetShaderiv, caps.glGetShaderInfoLog, caps.glGetShaderPrecisionFormat, caps.glGetShaderSource, caps.glGetString, caps.glGetTexParameterfv, caps.glGetTexParameteriv, caps.glGetUniformfv, caps.glGetUniformiv, caps.glGetUniformLocation, caps.glGetVertexAttribfv, caps.glGetVertexAttribiv, caps.glGetVertexAttribPointerv, caps.glHint, caps.glIsBuffer, caps.glIsEnabled, caps.glIsFramebuffer, caps.glIsProgram, caps.glIsRenderbuffer, caps.glIsShader, caps.glIsTexture, caps.glLineWidth, caps.glLinkProgram, caps.glPixelStorei, caps.glPolygonOffset, caps.glReadPixels, caps.glReleaseShaderCompiler, caps.glRenderbufferStorage, caps.glSampleCoverage, caps.glScissor, caps.glShaderBinary, caps.glShaderSource, caps.glStencilFunc, caps.glStencilFuncSeparate, caps.glStencilMask, caps.glStencilMaskSeparate, caps.glStencilOp, caps.glStencilOpSeparate, caps.glTexImage2D, caps.glTexParameterf, caps.glTexParameterfv, caps.glTexParameteri, caps.glTexParameteriv, caps.glTexSubImage2D, caps.glUniform1f, caps.glUniform1fv, caps.glUniform1i, caps.glUniform1iv, caps.glUniform2f, caps.glUniform2fv, caps.glUniform2i, caps.glUniform2iv, caps.glUniform3f, caps.glUniform3fv, caps.glUniform3i, caps.glUniform3iv, caps.glUniform4f, caps.glUniform4fv, caps.glUniform4i, caps.glUniform4iv, caps.glUniformMatrix2fv, caps.glUniformMatrix3fv, caps.glUniformMatrix4fv, caps.glUseProgram, caps.glValidateProgram, caps.glVertexAttrib1f, caps.glVertexAttrib1fv, caps.glVertexAttrib2f, caps.glVertexAttrib2fv, caps.glVertexAttrib3f, caps.glVertexAttrib3fv, caps.glVertexAttrib4f, caps.glVertexAttrib4fv, caps.glVertexAttribPointer, caps.glViewport);
    }

    public static void glActiveTexture(int texture) {
        long __functionAddress = GLES.getCapabilities().glActiveTexture;
        JNI.callV(__functionAddress, texture);
    }

    public static void glAttachShader(int program, int shader) {
        long __functionAddress = GLES.getCapabilities().glAttachShader;
        JNI.callV(__functionAddress, program, shader);
    }

    public static void nglBindAttribLocation(int program, int index, long name) {
        long __functionAddress = GLES.getCapabilities().glBindAttribLocation;
        JNI.callPV(__functionAddress, program, index, name);
    }

    public static void glBindAttribLocation(int program, int index, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        GLES20.nglBindAttribLocation(program, index, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glBindAttribLocation(int program, int index, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            GLES20.nglBindAttribLocation(program, index, MemoryUtil.memAddress(nameEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glBindBuffer(int target, int buffer) {
        long __functionAddress = GLES.getCapabilities().glBindBuffer;
        JNI.callV(__functionAddress, target, buffer);
    }

    public static void glBindFramebuffer(int target, int framebuffer) {
        long __functionAddress = GLES.getCapabilities().glBindFramebuffer;
        JNI.callV(__functionAddress, target, framebuffer);
    }

    public static void glBindRenderbuffer(int target, int renderbuffer) {
        long __functionAddress = GLES.getCapabilities().glBindRenderbuffer;
        JNI.callV(__functionAddress, target, renderbuffer);
    }

    public static void glBindTexture(int target, int texture) {
        long __functionAddress = GLES.getCapabilities().glBindTexture;
        JNI.callV(__functionAddress, target, texture);
    }

    public static void glBlendColor(float red, float green, float blue, float alpha) {
        long __functionAddress = GLES.getCapabilities().glBlendColor;
        JNI.callV(__functionAddress, red, green, blue, alpha);
    }

    public static void glBlendEquation(int mode) {
        long __functionAddress = GLES.getCapabilities().glBlendEquation;
        JNI.callV(__functionAddress, mode);
    }

    public static void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        long __functionAddress = GLES.getCapabilities().glBlendEquationSeparate;
        JNI.callV(__functionAddress, modeRGB, modeAlpha);
    }

    public static void glBlendFunc(int sfactor, int dfactor) {
        long __functionAddress = GLES.getCapabilities().glBlendFunc;
        JNI.callV(__functionAddress, sfactor, dfactor);
    }

    public static void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha) {
        long __functionAddress = GLES.getCapabilities().glBlendFuncSeparate;
        JNI.callV(__functionAddress, sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    }

    public static void nglBufferData(int target, long size, long data, int usage) {
        long __functionAddress = GLES.getCapabilities().glBufferData;
        JNI.callPPV(__functionAddress, target, size, data, usage);
    }

    public static void glBufferData(int target, long size, int usage) {
        GLES20.nglBufferData(target, size, 0L, usage);
    }

    public static void glBufferData(int target, ByteBuffer data, int usage) {
        GLES20.nglBufferData(target, data.remaining(), MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, ShortBuffer data, int usage) {
        GLES20.nglBufferData(target, data.remaining() << 1, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, IntBuffer data, int usage) {
        GLES20.nglBufferData(target, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferData(int target, FloatBuffer data, int usage) {
        GLES20.nglBufferData(target, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void nglBufferSubData(int target, long offset, long size, long data) {
        long __functionAddress = GLES.getCapabilities().glBufferSubData;
        JNI.callPPPV(__functionAddress, target, offset, size, data);
    }

    public static void glBufferSubData(int target, long offset, ByteBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, ShortBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, IntBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubData(int target, long offset, FloatBuffer data) {
        GLES20.nglBufferSubData(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static int glCheckFramebufferStatus(int target) {
        long __functionAddress = GLES.getCapabilities().glCheckFramebufferStatus;
        return JNI.callI(__functionAddress, target);
    }

    public static void glClear(int mask) {
        long __functionAddress = GLES.getCapabilities().glClear;
        JNI.callV(__functionAddress, mask);
    }

    public static void glClearColor(float red, float green, float blue, float alpha) {
        long __functionAddress = GLES.getCapabilities().glClearColor;
        JNI.callV(__functionAddress, red, green, blue, alpha);
    }

    public static void glClearDepthf(float d) {
        long __functionAddress = GLES.getCapabilities().glClearDepthf;
        JNI.callV(__functionAddress, d);
    }

    public static void glClearStencil(int s) {
        long __functionAddress = GLES.getCapabilities().glClearStencil;
        JNI.callV(__functionAddress, s);
    }

    public static void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        long __functionAddress = GLES.getCapabilities().glColorMask;
        JNI.callV(__functionAddress, red, green, blue, alpha);
    }

    public static void glCompileShader(int shader) {
        long __functionAddress = GLES.getCapabilities().glCompileShader;
        JNI.callV(__functionAddress, shader);
    }

    public static void nglCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, long data) {
        long __functionAddress = GLES.getCapabilities().glCompressedTexImage2D;
        JNI.callPV(__functionAddress, target, level, internalformat, width, height, border, imageSize, data);
    }

    public static void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, long data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        GLES20.nglCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
    }

    public static void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglCompressedTexImage2D(target, level, internalformat, width, height, border, data == null ? 0 : data.remaining(), MemoryUtil.memAddressSafe(data));
    }

    public static void nglCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        long __functionAddress = GLES.getCapabilities().glCompressedTexSubImage2D;
        JNI.callPV(__functionAddress, target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }

    public static void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        GLES20.nglCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }

    public static void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        long __functionAddress = GLES.getCapabilities().glCopyTexImage2D;
        JNI.callV(__functionAddress, target, level, internalformat, x, y, width, height, border);
    }

    public static void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        long __functionAddress = GLES.getCapabilities().glCopyTexSubImage2D;
        JNI.callV(__functionAddress, target, level, xoffset, yoffset, x, y, width, height);
    }

    public static int glCreateProgram() {
        long __functionAddress = GLES.getCapabilities().glCreateProgram;
        return JNI.callI(__functionAddress);
    }

    public static int glCreateShader(int type) {
        long __functionAddress = GLES.getCapabilities().glCreateShader;
        return JNI.callI(__functionAddress, type);
    }

    public static void glCullFace(int mode) {
        long __functionAddress = GLES.getCapabilities().glCullFace;
        JNI.callV(__functionAddress, mode);
    }

    public static void nglDeleteBuffers(int n, long buffers) {
        long __functionAddress = GLES.getCapabilities().glDeleteBuffers;
        JNI.callPV(__functionAddress, n, buffers);
    }

    public static void glDeleteBuffers(IntBuffer buffers) {
        GLES20.nglDeleteBuffers(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteBuffers(int buffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.ints(buffer);
            GLES20.nglDeleteBuffers(1, MemoryUtil.memAddress(buffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDeleteFramebuffers(int n, long framebuffers) {
        long __functionAddress = GLES.getCapabilities().glDeleteFramebuffers;
        JNI.callPV(__functionAddress, n, framebuffers);
    }

    public static void glDeleteFramebuffers(IntBuffer framebuffers) {
        GLES20.nglDeleteFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress(framebuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteFramebuffers(int framebuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer framebuffers = stack.ints(framebuffer);
            GLES20.nglDeleteFramebuffers(1, MemoryUtil.memAddress(framebuffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDeleteProgram(int program) {
        long __functionAddress = GLES.getCapabilities().glDeleteProgram;
        JNI.callV(__functionAddress, program);
    }

    public static void nglDeleteRenderbuffers(int n, long renderbuffers) {
        long __functionAddress = GLES.getCapabilities().glDeleteRenderbuffers;
        JNI.callPV(__functionAddress, n, renderbuffers);
    }

    public static void glDeleteRenderbuffers(IntBuffer renderbuffers) {
        GLES20.nglDeleteRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress(renderbuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteRenderbuffers(int renderbuffer) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer renderbuffers = stack.ints(renderbuffer);
            GLES20.nglDeleteRenderbuffers(1, MemoryUtil.memAddress(renderbuffers));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDeleteShader(int shader) {
        long __functionAddress = GLES.getCapabilities().glDeleteShader;
        JNI.callV(__functionAddress, shader);
    }

    public static void nglDeleteTextures(int n, long textures) {
        long __functionAddress = GLES.getCapabilities().glDeleteTextures;
        JNI.callPV(__functionAddress, n, textures);
    }

    public static void glDeleteTextures(IntBuffer textures) {
        GLES20.nglDeleteTextures(textures.remaining(), MemoryUtil.memAddress(textures));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteTextures(int texture) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer textures = stack.ints(texture);
            GLES20.nglDeleteTextures(1, MemoryUtil.memAddress(textures));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glDepthFunc(int func) {
        long __functionAddress = GLES.getCapabilities().glDepthFunc;
        JNI.callV(__functionAddress, func);
    }

    public static void glDepthMask(boolean flag) {
        long __functionAddress = GLES.getCapabilities().glDepthMask;
        JNI.callV(__functionAddress, flag);
    }

    public static void glDepthRangef(float n, float f) {
        long __functionAddress = GLES.getCapabilities().glDepthRangef;
        JNI.callV(__functionAddress, n, f);
    }

    public static void glDetachShader(int program, int shader) {
        long __functionAddress = GLES.getCapabilities().glDetachShader;
        JNI.callV(__functionAddress, program, shader);
    }

    public static void glDisable(int cap) {
        long __functionAddress = GLES.getCapabilities().glDisable;
        JNI.callV(__functionAddress, cap);
    }

    public static void glDisableVertexAttribArray(int index) {
        long __functionAddress = GLES.getCapabilities().glDisableVertexAttribArray;
        JNI.callV(__functionAddress, index);
    }

    public static void glDrawArrays(int mode, int first, int count) {
        long __functionAddress = GLES.getCapabilities().glDrawArrays;
        JNI.callV(__functionAddress, mode, first, count);
    }

    public static void nglDrawElements(int mode, int count, int type, long indices) {
        long __functionAddress = GLES.getCapabilities().glDrawElements;
        JNI.callPV(__functionAddress, mode, count, type, indices);
    }

    public static void glDrawElements(int mode, int count, int type, long indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        GLES20.nglDrawElements(mode, count, type, indices);
    }

    public static void glDrawElements(int mode, int type, ByteBuffer indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES20.nglDrawElements(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices));
    }

    public static void glDrawElements(int mode, ByteBuffer indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES20.nglDrawElements(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices));
    }

    public static void glDrawElements(int mode, ShortBuffer indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES20.nglDrawElements(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices));
    }

    public static void glDrawElements(int mode, IntBuffer indices) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        GLES20.nglDrawElements(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices));
    }

    public static void glEnable(int cap) {
        long __functionAddress = GLES.getCapabilities().glEnable;
        JNI.callV(__functionAddress, cap);
    }

    public static void glEnableVertexAttribArray(int index) {
        long __functionAddress = GLES.getCapabilities().glEnableVertexAttribArray;
        JNI.callV(__functionAddress, index);
    }

    public static void glFinish() {
        long __functionAddress = GLES.getCapabilities().glFinish;
        JNI.callV(__functionAddress);
    }

    public static void glFlush() {
        long __functionAddress = GLES.getCapabilities().glFlush;
        JNI.callV(__functionAddress);
    }

    public static void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        long __functionAddress = GLES.getCapabilities().glFramebufferRenderbuffer;
        JNI.callV(__functionAddress, target, attachment, renderbuffertarget, renderbuffer);
    }

    public static void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        long __functionAddress = GLES.getCapabilities().glFramebufferTexture2D;
        JNI.callV(__functionAddress, target, attachment, textarget, texture, level);
    }

    public static void glFrontFace(int mode) {
        long __functionAddress = GLES.getCapabilities().glFrontFace;
        JNI.callV(__functionAddress, mode);
    }

    public static void nglGenBuffers(int n, long buffers) {
        long __functionAddress = GLES.getCapabilities().glGenBuffers;
        JNI.callPV(__functionAddress, n, buffers);
    }

    public static void glGenBuffers(IntBuffer buffers) {
        GLES20.nglGenBuffers(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenBuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer buffers = stack.callocInt(1);
            GLES20.nglGenBuffers(1, MemoryUtil.memAddress(buffers));
            int n = buffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGenerateMipmap(int target) {
        long __functionAddress = GLES.getCapabilities().glGenerateMipmap;
        JNI.callV(__functionAddress, target);
    }

    public static void nglGenFramebuffers(int n, long framebuffers) {
        long __functionAddress = GLES.getCapabilities().glGenFramebuffers;
        JNI.callPV(__functionAddress, n, framebuffers);
    }

    public static void glGenFramebuffers(IntBuffer framebuffers) {
        GLES20.nglGenFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress(framebuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenFramebuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer framebuffers = stack.callocInt(1);
            GLES20.nglGenFramebuffers(1, MemoryUtil.memAddress(framebuffers));
            int n = framebuffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenRenderbuffers(int n, long renderbuffers) {
        long __functionAddress = GLES.getCapabilities().glGenRenderbuffers;
        JNI.callPV(__functionAddress, n, renderbuffers);
    }

    public static void glGenRenderbuffers(IntBuffer renderbuffers) {
        GLES20.nglGenRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress(renderbuffers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenRenderbuffers() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer renderbuffers = stack.callocInt(1);
            GLES20.nglGenRenderbuffers(1, MemoryUtil.memAddress(renderbuffers));
            int n = renderbuffers.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenTextures(int n, long textures) {
        long __functionAddress = GLES.getCapabilities().glGenTextures;
        JNI.callPV(__functionAddress, n, textures);
    }

    public static void glGenTextures(IntBuffer textures) {
        GLES20.nglGenTextures(textures.remaining(), MemoryUtil.memAddress(textures));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenTextures() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer textures = stack.callocInt(1);
            GLES20.nglGenTextures(1, MemoryUtil.memAddress(textures));
            int n = textures.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveAttrib(int program, int index, int bufSize, long length, long size, long type, long name) {
        long __functionAddress = GLES.getCapabilities().glGetActiveAttrib;
        JNI.callPPPPV(__functionAddress, program, index, bufSize, length, size, type, name);
    }

    public static void glGetActiveAttrib(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        GLES20.nglGetActiveAttrib(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveAttrib(int program, int index, int bufSize, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES20.nglGetActiveAttrib(program, index, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveAttrib(int program, int index, IntBuffer size, IntBuffer type) {
        int bufSize = GLES20.glGetProgrami(program, 35722);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES20.nglGetActiveAttrib(program, index, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveUniform(int program, int index, int bufSize, long length, long size, long type, long name) {
        long __functionAddress = GLES.getCapabilities().glGetActiveUniform;
        JNI.callPPPPV(__functionAddress, program, index, bufSize, length, size, type, name);
    }

    public static void glGetActiveUniform(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        GLES20.nglGetActiveUniform(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniform(int program, int index, int bufSize, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES20.nglGetActiveUniform(program, index, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniform(int program, int index, IntBuffer size, IntBuffer type) {
        int bufSize = GLES20.glGetProgrami(program, 35719);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufSize);
            GLES20.nglGetActiveUniform(program, index, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetAttachedShaders(int program, int maxCount, long count, long shaders) {
        long __functionAddress = GLES.getCapabilities().glGetAttachedShaders;
        JNI.callPPV(__functionAddress, program, maxCount, count, shaders);
    }

    public static void glGetAttachedShaders(int program, IntBuffer count, IntBuffer shaders) {
        if (Checks.CHECKS && count != null) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        GLES20.nglGetAttachedShaders(program, shaders.remaining(), MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(shaders));
    }

    public static int nglGetAttribLocation(int program, long name) {
        long __functionAddress = GLES.getCapabilities().glGetAttribLocation;
        return JNI.callPI(__functionAddress, program, name);
    }

    public static int glGetAttribLocation(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GLES20.nglGetAttribLocation(program, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetAttribLocation(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GLES20.nglGetAttribLocation(program, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetBooleanv(int pname, long data) {
        long __functionAddress = GLES.getCapabilities().glGetBooleanv;
        JNI.callPV(__functionAddress, pname, data);
    }

    public static void glGetBooleanv(int pname, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GLES20.nglGetBooleanv(pname, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte glGetBoolean(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer data = stack.calloc(1);
            GLES20.nglGetBooleanv(pname, MemoryUtil.memAddress(data));
            byte by = data.get(0);
            return by;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetBufferParameteriv(int target, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetBufferParameteriv;
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetBufferParameteri(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetBufferParameteriv(target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int glGetError() {
        long __functionAddress = GLES.getCapabilities().glGetError;
        return JNI.callI(__functionAddress);
    }

    public static void nglGetFloatv(int pname, long data) {
        long __functionAddress = GLES.getCapabilities().glGetFloatv;
        JNI.callPV(__functionAddress, pname, data);
    }

    public static void glGetFloatv(int pname, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GLES20.nglGetFloatv(pname, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetFloat(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer data = stack.callocFloat(1);
            GLES20.nglGetFloatv(pname, MemoryUtil.memAddress(data));
            float f = data.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetFramebufferAttachmentParameteriv;
        JNI.callPV(__functionAddress, target, attachment, pname, params);
    }

    public static void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetFramebufferAttachmentParameteri(int target, int attachment, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetIntegerv(int pname, long data) {
        long __functionAddress = GLES.getCapabilities().glGetIntegerv;
        JNI.callPV(__functionAddress, pname, data);
    }

    public static void glGetIntegerv(int pname, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GLES20.nglGetIntegerv(pname, MemoryUtil.memAddress(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetInteger(int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer data = stack.callocInt(1);
            GLES20.nglGetIntegerv(pname, MemoryUtil.memAddress(data));
            int n = data.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetProgramiv(int program, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetProgramiv;
        JNI.callPV(__functionAddress, program, pname, params);
    }

    public static void glGetProgramiv(int program, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetProgramiv(program, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgrami(int program, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetProgramiv(program, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetProgramInfoLog(int program, int bufSize, long length, long infoLog) {
        long __functionAddress = GLES.getCapabilities().glGetProgramInfoLog;
        JNI.callPPV(__functionAddress, program, bufSize, length, infoLog);
    }

    public static void glGetProgramInfoLog(int program, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES20.nglGetProgramInfoLog(program, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramInfoLog(int program, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetProgramInfoLog(program, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramInfoLog(int program) {
        int bufSize = GLES20.glGetProgrami(program, 35716);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetProgramInfoLog(program, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetRenderbufferParameteriv(int target, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetRenderbufferParameteriv;
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetRenderbufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetRenderbufferParameteri(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetRenderbufferParameteriv(target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetShaderiv(int shader, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetShaderiv;
        JNI.callPV(__functionAddress, shader, pname, params);
    }

    public static void glGetShaderiv(int shader, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetShaderi(int shader, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetShaderInfoLog(int shader, int bufSize, long length, long infoLog) {
        long __functionAddress = GLES.getCapabilities().glGetShaderInfoLog;
        JNI.callPPV(__functionAddress, shader, bufSize, length, infoLog);
    }

    public static void glGetShaderInfoLog(int shader, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES20.nglGetShaderInfoLog(shader, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderInfoLog(int shader, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetShaderInfoLog(shader, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderInfoLog(int shader) {
        int bufSize = GLES20.glGetShaderi(shader, 35716);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetShaderInfoLog(shader, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetShaderPrecisionFormat(int shadertype, int precisiontype, long range, long precision) {
        long __functionAddress = GLES.getCapabilities().glGetShaderPrecisionFormat;
        JNI.callPPV(__functionAddress, shadertype, precisiontype, range, precision);
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)range, 2);
            Checks.checkBuffer((Buffer)precision, 2);
        }
        GLES20.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
    }

    public static void nglGetShaderSource(int shader, int bufSize, long length, long source) {
        long __functionAddress = GLES.getCapabilities().glGetShaderSource;
        JNI.callPPV(__functionAddress, shader, bufSize, length, source);
    }

    public static void glGetShaderSource(int shader, IntBuffer length, ByteBuffer source) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GLES20.nglGetShaderSource(shader, source.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderSource(int shader, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc(bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetShaderSource(shader, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(source));
            String string = MemoryUtil.memUTF8(source, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(source);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderSource(int shader) {
        int bufSize = GLES20.glGetShaderi(shader, 35720);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc(bufSize);
        try {
            IntBuffer length = stack.ints(0);
            GLES20.nglGetShaderSource(shader, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(source));
            String string = MemoryUtil.memUTF8(source, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(source);
            stack.setPointer(stackPointer);
        }
    }

    public static long nglGetString(int name) {
        long __functionAddress = GLES.getCapabilities().glGetString;
        return JNI.callP(__functionAddress, name);
    }

    public static String glGetString(int name) {
        long __result = GLES20.nglGetString(name);
        return MemoryUtil.memUTF8(__result);
    }

    public static void nglGetTexParameterfv(int target, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetTexParameterfv;
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetTexParameterfv(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetTexParameterf(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GLES20.nglGetTexParameterfv(target, pname, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetTexParameteriv(int target, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetTexParameteriv;
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetTexParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetTexParameteri(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetTexParameteriv(target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetUniformfv(int program, int location, long params) {
        long __functionAddress = GLES.getCapabilities().glGetUniformfv;
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformfv(int program, int location, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetUniformfv(program, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetUniformf(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            GLES20.nglGetUniformfv(program, location, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetUniformiv(int program, int location, long params) {
        long __functionAddress = GLES.getCapabilities().glGetUniformiv;
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformiv(int program, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglGetUniformiv(program, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformi(int program, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            GLES20.nglGetUniformiv(program, location, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nglGetUniformLocation(int program, long name) {
        long __functionAddress = GLES.getCapabilities().glGetUniformLocation;
        return JNI.callPI(__functionAddress, program, name);
    }

    public static int glGetUniformLocation(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GLES20.nglGetUniformLocation(program, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformLocation(int program, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = GLES20.nglGetUniformLocation(program, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetVertexAttribfv(int index, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetVertexAttribfv;
        JNI.callPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetVertexAttribfv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetVertexAttribiv(int index, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetVertexAttribiv;
        JNI.callPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GLES20.nglGetVertexAttribiv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetVertexAttribPointerv(int index, int pname, long pointer) {
        long __functionAddress = GLES.getCapabilities().glGetVertexAttribPointerv;
        JNI.callPV(__functionAddress, index, pname, pointer);
    }

    public static void glGetVertexAttribPointerv(int index, int pname, PointerBuffer pointer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(pointer, 1);
        }
        GLES20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress(pointer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetVertexAttribPointer(int index, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer pointer = stack.callocPointer(1);
            GLES20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress(pointer));
            long l = pointer.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glHint(int target, int mode) {
        long __functionAddress = GLES.getCapabilities().glHint;
        JNI.callV(__functionAddress, target, mode);
    }

    public static boolean glIsBuffer(int buffer) {
        long __functionAddress = GLES.getCapabilities().glIsBuffer;
        return JNI.callZ(__functionAddress, buffer);
    }

    public static boolean glIsEnabled(int cap) {
        long __functionAddress = GLES.getCapabilities().glIsEnabled;
        return JNI.callZ(__functionAddress, cap);
    }

    public static boolean glIsFramebuffer(int framebuffer) {
        long __functionAddress = GLES.getCapabilities().glIsFramebuffer;
        return JNI.callZ(__functionAddress, framebuffer);
    }

    public static boolean glIsProgram(int program) {
        long __functionAddress = GLES.getCapabilities().glIsProgram;
        return JNI.callZ(__functionAddress, program);
    }

    public static boolean glIsRenderbuffer(int renderbuffer) {
        long __functionAddress = GLES.getCapabilities().glIsRenderbuffer;
        return JNI.callZ(__functionAddress, renderbuffer);
    }

    public static boolean glIsShader(int shader) {
        long __functionAddress = GLES.getCapabilities().glIsShader;
        return JNI.callZ(__functionAddress, shader);
    }

    public static boolean glIsTexture(int texture) {
        long __functionAddress = GLES.getCapabilities().glIsTexture;
        return JNI.callZ(__functionAddress, texture);
    }

    public static void glLineWidth(float width) {
        long __functionAddress = GLES.getCapabilities().glLineWidth;
        JNI.callV(__functionAddress, width);
    }

    public static void glLinkProgram(int program) {
        long __functionAddress = GLES.getCapabilities().glLinkProgram;
        JNI.callV(__functionAddress, program);
    }

    public static void glPixelStorei(int pname, int param) {
        long __functionAddress = GLES.getCapabilities().glPixelStorei;
        JNI.callV(__functionAddress, pname, param);
    }

    public static void glPolygonOffset(float factor, float units) {
        long __functionAddress = GLES.getCapabilities().glPolygonOffset;
        JNI.callV(__functionAddress, factor, units);
    }

    public static void nglReadPixels(int x, int y, int width, int height, int format, int type, long pixels) {
        long __functionAddress = GLES.getCapabilities().glReadPixels;
        JNI.callPV(__functionAddress, x, y, width, height, format, type, pixels);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, long pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, true);
        }
        GLES20.nglReadPixels(x, y, width, height, format, type, pixels);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        GLES20.nglReadPixels(x, y, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glReleaseShaderCompiler() {
        long __functionAddress = GLES.getCapabilities().glReleaseShaderCompiler;
        JNI.callV(__functionAddress);
    }

    public static void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        long __functionAddress = GLES.getCapabilities().glRenderbufferStorage;
        JNI.callV(__functionAddress, target, internalformat, width, height);
    }

    public static void glSampleCoverage(float value, boolean invert) {
        long __functionAddress = GLES.getCapabilities().glSampleCoverage;
        JNI.callV(__functionAddress, value, invert);
    }

    public static void glScissor(int x, int y, int width, int height) {
        long __functionAddress = GLES.getCapabilities().glScissor;
        JNI.callV(__functionAddress, x, y, width, height);
    }

    public static void nglShaderBinary(int count, long shaders, int binaryformat, long binary, int length) {
        long __functionAddress = GLES.getCapabilities().glShaderBinary;
        JNI.callPPV(__functionAddress, count, shaders, binaryformat, binary, length);
    }

    public static void glShaderBinary(IntBuffer shaders, int binaryformat, ByteBuffer binary) {
        GLES20.nglShaderBinary(shaders.remaining(), MemoryUtil.memAddress(shaders), binaryformat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void nglShaderSource(int shader, int count, long string, long length) {
        long __functionAddress = GLES.getCapabilities().glShaderSource;
        JNI.callPPV(__functionAddress, shader, count, string, length);
    }

    public static void glShaderSource(int shader, PointerBuffer string, IntBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, string.remaining());
        }
        GLES20.nglShaderSource(shader, string.remaining(), MemoryUtil.memAddress(string), MemoryUtil.memAddressSafe(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int shader, CharSequence ... string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringAddress = APIUtil.apiArrayUTF8i(stack, string);
            GLES20.nglShaderSource(shader, string.length, stringAddress, stringAddress - (long)(string.length << 2));
            APIUtil.apiArrayFree(stringAddress, string.length);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int shader, CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringAddress = APIUtil.apiArrayUTF8i(stack, string);
            GLES20.nglShaderSource(shader, 1, stringAddress, stringAddress - 4L);
            APIUtil.apiArrayFree(stringAddress, 1);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glStencilFunc(int func, int ref, int mask) {
        long __functionAddress = GLES.getCapabilities().glStencilFunc;
        JNI.callV(__functionAddress, func, ref, mask);
    }

    public static void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        long __functionAddress = GLES.getCapabilities().glStencilFuncSeparate;
        JNI.callV(__functionAddress, face, func, ref, mask);
    }

    public static void glStencilMask(int mask) {
        long __functionAddress = GLES.getCapabilities().glStencilMask;
        JNI.callV(__functionAddress, mask);
    }

    public static void glStencilMaskSeparate(int face, int mask) {
        long __functionAddress = GLES.getCapabilities().glStencilMaskSeparate;
        JNI.callV(__functionAddress, face, mask);
    }

    public static void glStencilOp(int fail, int zfail, int zpass) {
        long __functionAddress = GLES.getCapabilities().glStencilOp;
        JNI.callV(__functionAddress, fail, zfail, zpass);
    }

    public static void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        long __functionAddress = GLES.getCapabilities().glStencilOpSeparate;
        JNI.callV(__functionAddress, face, sfail, dpfail, dppass);
    }

    public static void nglTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels) {
        long __functionAddress = GLES.getCapabilities().glTexImage2D;
        JNI.callPV(__functionAddress, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, long pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexImage2D(target, level, internalformat, width, height, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexParameterf(int target, int pname, float param) {
        long __functionAddress = GLES.getCapabilities().glTexParameterf;
        JNI.callV(__functionAddress, target, pname, param);
    }

    public static void nglTexParameterfv(int target, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glTexParameterfv;
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glTexParameterfv(int target, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglTexParameterfv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glTexParameteri(int target, int pname, int param) {
        long __functionAddress = GLES.getCapabilities().glTexParameteri;
        JNI.callV(__functionAddress, target, pname, param);
    }

    public static void nglTexParameteriv(int target, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glTexParameteriv;
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glTexParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GLES20.nglTexParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void nglTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        long __functionAddress = GLES.getCapabilities().glTexSubImage2D;
        JNI.callPV(__functionAddress, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, true);
        }
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        GLES20.nglTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glUniform1f(int location, float v0) {
        long __functionAddress = GLES.getCapabilities().glUniform1f;
        JNI.callV(__functionAddress, location, v0);
    }

    public static void nglUniform1fv(int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glUniform1fv;
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform1fv(int location, FloatBuffer value) {
        GLES20.nglUniform1fv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void glUniform1i(int location, int v0) {
        long __functionAddress = GLES.getCapabilities().glUniform1i;
        JNI.callV(__functionAddress, location, v0);
    }

    public static void nglUniform1iv(int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glUniform1iv;
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform1iv(int location, IntBuffer value) {
        GLES20.nglUniform1iv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void glUniform2f(int location, float v0, float v1) {
        long __functionAddress = GLES.getCapabilities().glUniform2f;
        JNI.callV(__functionAddress, location, v0, v1);
    }

    public static void nglUniform2fv(int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glUniform2fv;
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform2fv(int location, FloatBuffer value) {
        GLES20.nglUniform2fv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void glUniform2i(int location, int v0, int v1) {
        long __functionAddress = GLES.getCapabilities().glUniform2i;
        JNI.callV(__functionAddress, location, v0, v1);
    }

    public static void nglUniform2iv(int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glUniform2iv;
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform2iv(int location, IntBuffer value) {
        GLES20.nglUniform2iv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void glUniform3f(int location, float v0, float v1, float v2) {
        long __functionAddress = GLES.getCapabilities().glUniform3f;
        JNI.callV(__functionAddress, location, v0, v1, v2);
    }

    public static void nglUniform3fv(int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glUniform3fv;
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform3fv(int location, FloatBuffer value) {
        GLES20.nglUniform3fv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void glUniform3i(int location, int v0, int v1, int v2) {
        long __functionAddress = GLES.getCapabilities().glUniform3i;
        JNI.callV(__functionAddress, location, v0, v1, v2);
    }

    public static void nglUniform3iv(int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glUniform3iv;
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform3iv(int location, IntBuffer value) {
        GLES20.nglUniform3iv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void glUniform4f(int location, float v0, float v1, float v2, float v3) {
        long __functionAddress = GLES.getCapabilities().glUniform4f;
        JNI.callV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void nglUniform4fv(int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glUniform4fv;
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform4fv(int location, FloatBuffer value) {
        GLES20.nglUniform4fv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void glUniform4i(int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GLES.getCapabilities().glUniform4i;
        JNI.callV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void nglUniform4iv(int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glUniform4iv;
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform4iv(int location, IntBuffer value) {
        GLES20.nglUniform4iv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES.getCapabilities().glUniformMatrix2fv;
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2fv(int location, boolean transpose, FloatBuffer value) {
        GLES20.nglUniformMatrix2fv(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES.getCapabilities().glUniformMatrix3fv;
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3fv(int location, boolean transpose, FloatBuffer value) {
        GLES20.nglUniformMatrix3fv(location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES.getCapabilities().glUniformMatrix4fv;
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4fv(int location, boolean transpose, FloatBuffer value) {
        GLES20.nglUniformMatrix4fv(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUseProgram(int program) {
        long __functionAddress = GLES.getCapabilities().glUseProgram;
        JNI.callV(__functionAddress, program);
    }

    public static void glValidateProgram(int program) {
        long __functionAddress = GLES.getCapabilities().glValidateProgram;
        JNI.callV(__functionAddress, program);
    }

    public static void glVertexAttrib1f(int index, float x) {
        long __functionAddress = GLES.getCapabilities().glVertexAttrib1f;
        JNI.callV(__functionAddress, index, x);
    }

    public static void nglVertexAttrib1fv(int index, long v) {
        long __functionAddress = GLES.getCapabilities().glVertexAttrib1fv;
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib1fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GLES20.nglVertexAttrib1fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib2f(int index, float x, float y) {
        long __functionAddress = GLES.getCapabilities().glVertexAttrib2f;
        JNI.callV(__functionAddress, index, x, y);
    }

    public static void nglVertexAttrib2fv(int index, long v) {
        long __functionAddress = GLES.getCapabilities().glVertexAttrib2fv;
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib2fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GLES20.nglVertexAttrib2fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib3f(int index, float x, float y, float z) {
        long __functionAddress = GLES.getCapabilities().glVertexAttrib3f;
        JNI.callV(__functionAddress, index, x, y, z);
    }

    public static void nglVertexAttrib3fv(int index, long v) {
        long __functionAddress = GLES.getCapabilities().glVertexAttrib3fv;
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib3fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GLES20.nglVertexAttrib3fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4f(int index, float x, float y, float z, float w) {
        long __functionAddress = GLES.getCapabilities().glVertexAttrib4f;
        JNI.callV(__functionAddress, index, x, y, z, w);
    }

    public static void nglVertexAttrib4fv(int index, long v) {
        long __functionAddress = GLES.getCapabilities().glVertexAttrib4fv;
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4fv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GLES20.nglVertexAttrib4fv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        long __functionAddress = GLES.getCapabilities().glVertexAttribPointer;
        JNI.callPV(__functionAddress, index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, true);
        }
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ShortBuffer pointer) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, IntBuffer pointer) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, FloatBuffer pointer) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        GLES20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glViewport(int x, int y, int width, int height) {
        long __functionAddress = GLES.getCapabilities().glViewport;
        JNI.callV(__functionAddress, x, y, width, height);
    }

    public static void glBufferData(int target, short[] data, int usage) {
        long __functionAddress = GLES.getCapabilities().glBufferData;
        JNI.callPPV(__functionAddress, target, (long)(data.length << 1), data, usage);
    }

    public static void glBufferData(int target, int[] data, int usage) {
        long __functionAddress = GLES.getCapabilities().glBufferData;
        JNI.callPPV(__functionAddress, target, (long)(data.length << 2), data, usage);
    }

    public static void glBufferData(int target, float[] data, int usage) {
        long __functionAddress = GLES.getCapabilities().glBufferData;
        JNI.callPPV(__functionAddress, target, (long)(data.length << 2), data, usage);
    }

    public static void glBufferSubData(int target, long offset, short[] data) {
        long __functionAddress = GLES.getCapabilities().glBufferSubData;
        JNI.callPPPV(__functionAddress, target, offset, (long)(data.length << 1), data);
    }

    public static void glBufferSubData(int target, long offset, int[] data) {
        long __functionAddress = GLES.getCapabilities().glBufferSubData;
        JNI.callPPPV(__functionAddress, target, offset, (long)(data.length << 2), data);
    }

    public static void glBufferSubData(int target, long offset, float[] data) {
        long __functionAddress = GLES.getCapabilities().glBufferSubData;
        JNI.callPPPV(__functionAddress, target, offset, (long)(data.length << 2), data);
    }

    public static void glDeleteBuffers(int[] buffers) {
        long __functionAddress = GLES.getCapabilities().glDeleteBuffers;
        JNI.callPV(__functionAddress, buffers.length, buffers);
    }

    public static void glDeleteFramebuffers(int[] framebuffers) {
        long __functionAddress = GLES.getCapabilities().glDeleteFramebuffers;
        JNI.callPV(__functionAddress, framebuffers.length, framebuffers);
    }

    public static void glDeleteRenderbuffers(int[] renderbuffers) {
        long __functionAddress = GLES.getCapabilities().glDeleteRenderbuffers;
        JNI.callPV(__functionAddress, renderbuffers.length, renderbuffers);
    }

    public static void glDeleteTextures(int[] textures) {
        long __functionAddress = GLES.getCapabilities().glDeleteTextures;
        JNI.callPV(__functionAddress, textures.length, textures);
    }

    public static void glGenBuffers(int[] buffers) {
        long __functionAddress = GLES.getCapabilities().glGenBuffers;
        JNI.callPV(__functionAddress, buffers.length, buffers);
    }

    public static void glGenFramebuffers(int[] framebuffers) {
        long __functionAddress = GLES.getCapabilities().glGenFramebuffers;
        JNI.callPV(__functionAddress, framebuffers.length, framebuffers);
    }

    public static void glGenRenderbuffers(int[] renderbuffers) {
        long __functionAddress = GLES.getCapabilities().glGenRenderbuffers;
        JNI.callPV(__functionAddress, renderbuffers.length, renderbuffers);
    }

    public static void glGenTextures(int[] textures) {
        long __functionAddress = GLES.getCapabilities().glGenTextures;
        JNI.callPV(__functionAddress, textures.length, textures);
    }

    public static void glGetActiveAttrib(int program, int index, int[] length, int[] size, int[] type, ByteBuffer name) {
        long __functionAddress = GLES.getCapabilities().glGetActiveAttrib;
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
            Checks.checkBuffer(size, 1);
            Checks.checkBuffer(type, 1);
        }
        JNI.callPPPPV(__functionAddress, program, index, name.remaining(), length, size, type, MemoryUtil.memAddress(name));
    }

    public static void glGetActiveUniform(int program, int index, int[] length, int[] size, int[] type, ByteBuffer name) {
        long __functionAddress = GLES.getCapabilities().glGetActiveUniform;
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
            Checks.checkBuffer(size, 1);
            Checks.checkBuffer(type, 1);
        }
        JNI.callPPPPV(__functionAddress, program, index, name.remaining(), length, size, type, MemoryUtil.memAddress(name));
    }

    public static void glGetAttachedShaders(int program, int[] count, int[] shaders) {
        long __functionAddress = GLES.getCapabilities().glGetAttachedShaders;
        if (Checks.CHECKS && count != null) {
            Checks.checkBuffer(count, 1);
        }
        JNI.callPPV(__functionAddress, program, shaders.length, count, shaders);
    }

    public static void glGetBufferParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetBufferParameteriv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetFloatv(int pname, float[] data) {
        long __functionAddress = GLES.getCapabilities().glGetFloatv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(data, 1);
        }
        JNI.callPV(__functionAddress, pname, data);
    }

    public static void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetFramebufferAttachmentParameteriv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, attachment, pname, params);
    }

    public static void glGetIntegerv(int pname, int[] data) {
        long __functionAddress = GLES.getCapabilities().glGetIntegerv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(data, 1);
        }
        JNI.callPV(__functionAddress, pname, data);
    }

    public static void glGetProgramiv(int program, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetProgramiv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, program, pname, params);
    }

    public static void glGetProgramInfoLog(int program, int[] length, ByteBuffer infoLog) {
        long __functionAddress = GLES.getCapabilities().glGetProgramInfoLog;
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer(length, 1);
        }
        JNI.callPPV(__functionAddress, program, infoLog.remaining(), length, MemoryUtil.memAddress(infoLog));
    }

    public static void glGetRenderbufferParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetRenderbufferParameteriv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetShaderiv(int shader, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetShaderiv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, shader, pname, params);
    }

    public static void glGetShaderInfoLog(int shader, int[] length, ByteBuffer infoLog) {
        long __functionAddress = GLES.getCapabilities().glGetShaderInfoLog;
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer(length, 1);
        }
        JNI.callPPV(__functionAddress, shader, infoLog.remaining(), length, MemoryUtil.memAddress(infoLog));
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, int[] range, int[] precision) {
        long __functionAddress = GLES.getCapabilities().glGetShaderPrecisionFormat;
        if (Checks.CHECKS) {
            Checks.checkBuffer(range, 2);
            Checks.checkBuffer(precision, 2);
        }
        JNI.callPPV(__functionAddress, shadertype, precisiontype, range, precision);
    }

    public static void glGetShaderSource(int shader, int[] length, ByteBuffer source) {
        long __functionAddress = GLES.getCapabilities().glGetShaderSource;
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer(length, 1);
        }
        JNI.callPPV(__functionAddress, shader, source.remaining(), length, MemoryUtil.memAddress(source));
    }

    public static void glGetTexParameterfv(int target, int pname, float[] params) {
        long __functionAddress = GLES.getCapabilities().glGetTexParameterfv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetTexParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetTexParameteriv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetUniformfv(int program, int location, float[] params) {
        long __functionAddress = GLES.getCapabilities().glGetUniformfv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformiv(int program, int location, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetUniformiv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, program, location, params);
    }

    public static void glGetVertexAttribfv(int index, int pname, float[] params) {
        long __functionAddress = GLES.getCapabilities().glGetVertexAttribfv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribiv(int index, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetVertexAttribiv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 4);
        }
        JNI.callPV(__functionAddress, index, pname, params);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GLES.getCapabilities().glReadPixels;
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, pixels);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GLES.getCapabilities().glReadPixels;
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, pixels);
    }

    public static void glReadPixels(int x, int y, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GLES.getCapabilities().glReadPixels;
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        JNI.callPV(__functionAddress, x, y, width, height, format, type, pixels);
    }

    public static void glShaderBinary(int[] shaders, int binaryformat, ByteBuffer binary) {
        long __functionAddress = GLES.getCapabilities().glShaderBinary;
        JNI.callPPV(__functionAddress, shaders.length, shaders, binaryformat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void glShaderSource(int shader, PointerBuffer string, int[] length) {
        long __functionAddress = GLES.getCapabilities().glShaderSource;
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer(length, string.remaining());
        }
        JNI.callPPV(__functionAddress, shader, string.remaining(), MemoryUtil.memAddress(string), length);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, short[] pixels) {
        long __functionAddress = GLES.getCapabilities().glTexImage2D;
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        JNI.callPV(__functionAddress, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, int[] pixels) {
        long __functionAddress = GLES.getCapabilities().glTexImage2D;
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        JNI.callPV(__functionAddress, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, float[] pixels) {
        long __functionAddress = GLES.getCapabilities().glTexImage2D;
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        JNI.callPV(__functionAddress, target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void glTexParameterfv(int target, int pname, float[] params) {
        long __functionAddress = GLES.getCapabilities().glTexParameterfv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glTexParameteriv(int target, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glTexParameteriv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, short[] pixels) {
        long __functionAddress = GLES.getCapabilities().glTexSubImage2D;
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        JNI.callPV(__functionAddress, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, int[] pixels) {
        long __functionAddress = GLES.getCapabilities().glTexSubImage2D;
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        JNI.callPV(__functionAddress, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, float[] pixels) {
        long __functionAddress = GLES.getCapabilities().glTexSubImage2D;
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35055, false);
        }
        JNI.callPV(__functionAddress, target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void glUniform1fv(int location, float[] value) {
        long __functionAddress = GLES.getCapabilities().glUniform1fv;
        JNI.callPV(__functionAddress, location, value.length, value);
    }

    public static void glUniform1iv(int location, int[] value) {
        long __functionAddress = GLES.getCapabilities().glUniform1iv;
        JNI.callPV(__functionAddress, location, value.length, value);
    }

    public static void glUniform2fv(int location, float[] value) {
        long __functionAddress = GLES.getCapabilities().glUniform2fv;
        JNI.callPV(__functionAddress, location, value.length >> 1, value);
    }

    public static void glUniform2iv(int location, int[] value) {
        long __functionAddress = GLES.getCapabilities().glUniform2iv;
        JNI.callPV(__functionAddress, location, value.length >> 1, value);
    }

    public static void glUniform3fv(int location, float[] value) {
        long __functionAddress = GLES.getCapabilities().glUniform3fv;
        JNI.callPV(__functionAddress, location, value.length / 3, value);
    }

    public static void glUniform3iv(int location, int[] value) {
        long __functionAddress = GLES.getCapabilities().glUniform3iv;
        JNI.callPV(__functionAddress, location, value.length / 3, value);
    }

    public static void glUniform4fv(int location, float[] value) {
        long __functionAddress = GLES.getCapabilities().glUniform4fv;
        JNI.callPV(__functionAddress, location, value.length >> 2, value);
    }

    public static void glUniform4iv(int location, int[] value) {
        long __functionAddress = GLES.getCapabilities().glUniform4iv;
        JNI.callPV(__functionAddress, location, value.length >> 2, value);
    }

    public static void glUniformMatrix2fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getCapabilities().glUniformMatrix2fv;
        JNI.callPV(__functionAddress, location, value.length >> 2, transpose, value);
    }

    public static void glUniformMatrix3fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getCapabilities().glUniformMatrix3fv;
        JNI.callPV(__functionAddress, location, value.length / 9, transpose, value);
    }

    public static void glUniformMatrix4fv(int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getCapabilities().glUniformMatrix4fv;
        JNI.callPV(__functionAddress, location, value.length >> 4, transpose, value);
    }

    public static void glVertexAttrib1fv(int index, float[] v) {
        long __functionAddress = GLES.getCapabilities().glVertexAttrib1fv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(v, 1);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib2fv(int index, float[] v) {
        long __functionAddress = GLES.getCapabilities().glVertexAttrib2fv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(v, 2);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib3fv(int index, float[] v) {
        long __functionAddress = GLES.getCapabilities().glVertexAttrib3fv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(v, 3);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttrib4fv(int index, float[] v) {
        long __functionAddress = GLES.getCapabilities().glVertexAttrib4fv;
        if (Checks.CHECKS) {
            Checks.checkBuffer(v, 4);
        }
        JNI.callPV(__functionAddress, index, v);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, short[] pointer) {
        long __functionAddress = GLES.getCapabilities().glVertexAttribPointer;
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        JNI.callPV(__functionAddress, index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, int[] pointer) {
        long __functionAddress = GLES.getCapabilities().glVertexAttribPointer;
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        JNI.callPV(__functionAddress, index, size, type, normalized, stride, pointer);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, float[] pointer) {
        long __functionAddress = GLES.getCapabilities().glVertexAttribPointer;
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34964, false);
        }
        JNI.callPV(__functionAddress, index, size, type, normalized, stride, pointer);
    }
}

