/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.lwjgl.egl.EGL;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESUtil;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.ThreadLocalUtil;

public final class GLES {
    private static final APIUtil.APIVersion MAX_VERSION = APIUtil.apiParseVersion(Configuration.OPENGLES_MAXVERSION);
    private static FunctionProvider functionProvider;
    private static final CapabilitiesState capabilitiesState;

    private GLES() {
    }

    public static void create() {
        SharedLibrary GLES2;
        switch (Platform.get()) {
            case LINUX: {
                GLES2 = Library.loadNative(Configuration.OPENGLES_LIBRARY_NAME, "libGLESv2.so.2");
                break;
            }
            case MACOSX: {
                GLES2 = Library.loadNative(Configuration.OPENGLES_LIBRARY_NAME, "GLESv2");
                break;
            }
            case WINDOWS: {
                GLES2 = Library.loadNative(Configuration.OPENGLES_LIBRARY_NAME, "libGLESv2", "GLESv2");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        GLES.create(GLES2);
    }

    public static void create(String libName) {
        GLES.create(Library.loadNative(libName));
    }

    private static void create(SharedLibrary GLES2) {
        try {
            GLES.create((FunctionProvider)new SharedLibrary.Delegate(GLES2){

                @Override
                public long getFunctionAddress(ByteBuffer functionName) {
                    long address = EGL.getFunctionProvider().getFunctionAddress(functionName);
                    if (address == 0L && (address = this.library.getFunctionAddress(functionName)) == 0L && Checks.DEBUG_FUNCTIONS) {
                        APIUtil.apiLog("Failed to locate address for GLES function " + functionName);
                    }
                    return address;
                }
            });
        }
        catch (RuntimeException e) {
            GLES2.free();
            throw e;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (GLES.functionProvider != null) {
            throw new IllegalStateException("OpenGL ES has already been created.");
        }
        GLES.functionProvider = functionProvider;
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
    }

    public static FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    public static void setCapabilities(GLESCapabilities caps) {
        capabilitiesState.set(caps);
    }

    public static GLESCapabilities getCapabilities() {
        GLESCapabilities caps = capabilitiesState.get();
        if (caps == null) {
            throw new IllegalStateException("No GLESCapabilities instance has been set for the current thread.");
        }
        return caps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GLESCapabilities createCapabilities() {
        GLESCapabilities caps = null;
        try {
            int minorVersion;
            int majorVersion;
            long GetError = functionProvider.getFunctionAddress("glGetError");
            long GetString = functionProvider.getFunctionAddress("glGetString");
            long GetIntegerv = functionProvider.getFunctionAddress("glGetIntegerv");
            if (GetError == 0L || GetString == 0L || GetIntegerv == 0L) {
                throw new IllegalStateException("Core OpenGL ES functions could not be found. Make sure that the OpenGL ES library has been loaded correctly.");
            }
            int errorCode = JNI.invokeI(GetError);
            if (errorCode != 0) {
                APIUtil.apiLog("An OpenGL ES context was in an error state before the creation of its capabilities instance. Error: " + GLESUtil.getErrorString(errorCode));
            }
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer pi = stack.ints(0);
                JNI.invokePV(GetIntegerv, 33307, MemoryUtil.memAddress(pi));
                if (JNI.invokeI(GetError) == 0 && 3 <= (majorVersion = pi.get(0))) {
                    JNI.invokePV(GetIntegerv, 33308, MemoryUtil.memAddress(pi));
                    minorVersion = pi.get(0);
                } else {
                    long versionString = JNI.invokeP(GetString, 7938);
                    if (versionString == 0L || JNI.invokeI(GetError) != 0) {
                        throw new IllegalStateException("There is no OpenGL ES context current in the current thread.");
                    }
                    APIUtil.APIVersion version = APIUtil.apiParseVersion(MemoryUtil.memUTF8(versionString), "OpenGL ES");
                    majorVersion = version.major;
                    minorVersion = version.minor;
                }
            }
            if (majorVersion < 2) {
                throw new IllegalStateException("OpenGL ES 2.0 is required.");
            }
            int[] GL_VERSIONS = new int[]{-1, 0, 2};
            HashSet<String> supportedExtensions = new HashSet<String>(128);
            int maxMajor = Math.min(majorVersion, GL_VERSIONS.length);
            if (MAX_VERSION != null) {
                maxMajor = Math.min(GLES.MAX_VERSION.major, maxMajor);
            }
            for (int M = 2; M <= maxMajor; ++M) {
                int maxMinor = GL_VERSIONS[M - 1];
                if (M == majorVersion) {
                    maxMinor = Math.min(minorVersion, maxMinor);
                }
                if (MAX_VERSION != null && M == GLES.MAX_VERSION.major) {
                    maxMinor = Math.min(GLES.MAX_VERSION.minor, maxMinor);
                }
                for (int m = 0; m <= maxMinor; ++m) {
                    supportedExtensions.add(String.format("GLES%d%d", M, m));
                }
            }
            if (majorVersion < 3) {
                String extensionsString = MemoryUtil.memASCII(Checks.checkPointer(JNI.invokeP(GetString, 7939)));
                StringTokenizer tokenizer = new StringTokenizer(extensionsString);
                while (tokenizer.hasMoreTokens()) {
                    supportedExtensions.add(tokenizer.nextToken());
                }
            } else {
                int extensionCount;
                try (MemoryStack stack = MemoryStack.stackPush();){
                    IntBuffer pi = stack.ints(0);
                    JNI.invokePV(GetIntegerv, 33309, MemoryUtil.memAddress(pi));
                    extensionCount = pi.get(0);
                }
                long GetStringi = APIUtil.apiGetFunctionAddress(functionProvider, "glGetStringi");
                for (int i = 0; i < extensionCount; ++i) {
                    supportedExtensions.add(MemoryUtil.memASCII(Checks.checkPointer(JNI.callP(GetStringi, 7939, i))));
                }
            }
            caps = new GLESCapabilities(GLES.getFunctionProvider(), supportedExtensions);
        }
        catch (Throwable throwable) {
            GLES.setCapabilities(caps);
            throw throwable;
        }
        GLES.setCapabilities(caps);
        return caps;
    }

    static boolean checkExtension(String extension, boolean supported) {
        if (supported) {
            return true;
        }
        APIUtil.apiLog("[GLES] " + extension + " was reported as available but an entry point is missing.");
        return false;
    }

    static {
        String capsStateType = Configuration.OPENGLES_CAPABILITIES_STATE.get("ThreadLocal");
        if ("static".equals(capsStateType)) {
            capabilitiesState = new StaticCapabilitiesState();
        } else if ("ThreadLocal".equals(capsStateType)) {
            capabilitiesState = new TLCapabilitiesState();
        } else {
            throw new IllegalStateException("Invalid " + Configuration.OPENGLES_CAPABILITIES_STATE.getProperty() + " specified.");
        }
        if (!Configuration.OPENGLES_EXPLICIT_INIT.get(false).booleanValue()) {
            GLES.create();
        }
    }

    private static class StaticCapabilitiesState
    implements CapabilitiesState {
        private static final List<Field> flags;
        private static final List<Field> funcs;
        private static GLESCapabilities tempCaps;

        private StaticCapabilitiesState() {
        }

        @Override
        public void set(GLESCapabilities caps) {
            if (Checks.DEBUG) {
                StaticCapabilitiesState.checkCapabilities(caps);
            }
            tempCaps = caps;
        }

        private static void checkCapabilities(GLESCapabilities caps) {
            if (caps != null && tempCaps != null && !APIUtil.apiCompareCapabilities(flags, funcs, tempCaps, caps)) {
                APIUtil.apiLog("An OpenGL ES context with different functionality detected! The ThreadLocal capabilities state must be used.");
            }
        }

        @Override
        public GLESCapabilities get() {
            return WriteOnce.caps;
        }

        static /* synthetic */ GLESCapabilities access$300() {
            return tempCaps;
        }

        static {
            if (Checks.DEBUG) {
                Field[] fields = GLESCapabilities.class.getFields();
                flags = new ArrayList<Field>(256);
                funcs = new ArrayList<Field>(128);
                for (Field f : fields) {
                    (f.getType() == Boolean.TYPE ? flags : funcs).add(f);
                }
            } else {
                flags = null;
                funcs = null;
            }
        }

        private static final class WriteOnce {
            private static final GLESCapabilities caps = StaticCapabilitiesState.access$300();

            private WriteOnce() {
            }

            static {
                if (caps == null) {
                    throw new IllegalStateException("The static GLESCapabilities instance is null");
                }
            }
        }
    }

    private static class TLCapabilitiesState
    implements CapabilitiesState {
        private TLCapabilitiesState() {
        }

        @Override
        public void set(GLESCapabilities caps) {
            ThreadLocalUtil.tlsGet().capsGLES = caps;
        }

        @Override
        public GLESCapabilities get() {
            return ThreadLocalUtil.tlsGet().capsGLES;
        }
    }

    private static interface CapabilitiesState {
        public void set(GLESCapabilities var1);

        public GLESCapabilities get();
    }
}

