/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XVisualInfo;

public class GLX {
    public static final int GLXBadContext = 0;
    public static final int GLXBadContextState = 1;
    public static final int GLXBadDrawable = 2;
    public static final int GLXBadPixmap = 3;
    public static final int GLXBadContextTag = 4;
    public static final int GLXBadCurrentWindow = 5;
    public static final int GLXBadRenderRequest = 6;
    public static final int GLXBadLargeRequest = 7;
    public static final int GLXUnsupportedPrivateRequest = 8;
    public static final int GLXBadFBConfig = 9;
    public static final int GLXBadPbuffer = 10;
    public static final int GLXBadCurrentDrawable = 11;
    public static final int GLXBadWindow = 12;
    public static final int GLX_USE_GL = 1;
    public static final int GLX_BUFFER_SIZE = 2;
    public static final int GLX_LEVEL = 3;
    public static final int GLX_RGBA = 4;
    public static final int GLX_DOUBLEBUFFER = 5;
    public static final int GLX_STEREO = 6;
    public static final int GLX_AUX_BUFFERS = 7;
    public static final int GLX_RED_SIZE = 8;
    public static final int GLX_GREEN_SIZE = 9;
    public static final int GLX_BLUE_SIZE = 10;
    public static final int GLX_ALPHA_SIZE = 11;
    public static final int GLX_DEPTH_SIZE = 12;
    public static final int GLX_STENCIL_SIZE = 13;
    public static final int GLX_ACCUM_RED_SIZE = 14;
    public static final int GLX_ACCUM_GREEN_SIZE = 15;
    public static final int GLX_ACCUM_BLUE_SIZE = 16;
    public static final int GLX_ACCUM_ALPHA_SIZE = 17;
    public static final int GLX_BAD_SCREEN = 1;
    public static final int GLX_BAD_ATTRIBUTE = 2;
    public static final int GLX_NO_EXTENSION = 3;
    public static final int GLX_BAD_VISUAL = 4;
    public static final int GLX_BAD_CONTEXT = 5;
    public static final int GLX_BAD_VALUE = 6;
    public static final int GLX_BAD_ENUM = 7;

    protected GLX() {
        throw new UnsupportedOperationException();
    }

    public static int nglXQueryExtension(long display, long error_base, long event_base) {
        long __functionAddress = Functions.QueryExtension;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPPPI(__functionAddress, display, error_base, event_base);
    }

    public static int glXQueryExtension(long display, IntBuffer error_base, IntBuffer event_base) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)error_base, 1);
            Checks.checkBuffer((Buffer)event_base, 1);
        }
        return GLX.nglXQueryExtension(display, MemoryUtil.memAddress(error_base), MemoryUtil.memAddress(event_base));
    }

    public static int nglXQueryVersion(long display, long major, long minor) {
        long __functionAddress = Functions.QueryVersion;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPPPI(__functionAddress, display, major, minor);
    }

    public static int glXQueryVersion(long display, IntBuffer major, IntBuffer minor) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)major, 1);
            Checks.checkBuffer((Buffer)minor, 1);
        }
        return GLX.nglXQueryVersion(display, MemoryUtil.memAddress(major), MemoryUtil.memAddress(minor));
    }

    public static int nglXGetConfig(long display, long visual, int attribute, long value) {
        long __functionAddress = Functions.GetConfig;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            XVisualInfo.validate(visual);
        }
        return JNI.callPPPI(__functionAddress, display, visual, attribute, value);
    }

    public static int glXGetConfig(long display, XVisualInfo visual, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return GLX.nglXGetConfig(display, visual.address(), attribute, MemoryUtil.memAddress(value));
    }

    public static long nglXChooseVisual(long display, int screen, long attrib_list) {
        long __functionAddress = Functions.ChooseVisual;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPPP(__functionAddress, display, screen, attrib_list);
    }

    public static XVisualInfo glXChooseVisual(long display, int screen, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list);
        }
        long __result = GLX.nglXChooseVisual(display, screen, MemoryUtil.memAddressSafe(attrib_list));
        return XVisualInfo.create(__result);
    }

    public static long nglXCreateContext(long display, long visual, long share_list, int direct) {
        long __functionAddress = Functions.CreateContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            XVisualInfo.validate(visual);
        }
        return JNI.callPPPP(__functionAddress, display, visual, share_list, direct);
    }

    public static long glXCreateContext(long display, XVisualInfo visual, long share_list, int direct) {
        return GLX.nglXCreateContext(display, visual.address(), share_list, direct);
    }

    public static int glXMakeCurrent(long display, long draw, long ctx) {
        long __functionAddress = Functions.MakeCurrent;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
        }
        return JNI.callPPPI(__functionAddress, display, draw, ctx);
    }

    public static void glXCopyContext(long display, long source, long dest, long mask) {
        long __functionAddress = Functions.CopyContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(source);
            Checks.checkPointer(dest);
        }
        JNI.callPPPPV(__functionAddress, display, source, dest, mask);
    }

    public static int glXIsDirect(long display, long ctx) {
        long __functionAddress = Functions.IsDirect;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(ctx);
        }
        return JNI.callPPI(__functionAddress, display, ctx);
    }

    public static void glXDestroyContext(long display, long ctx) {
        long __functionAddress = Functions.DestroyContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(ctx);
        }
        JNI.callPPV(__functionAddress, display, ctx);
    }

    public static long glXGetCurrentContext() {
        long __functionAddress = Functions.GetCurrentContext;
        return JNI.callP(__functionAddress);
    }

    public static long glXGetCurrentDrawable() {
        long __functionAddress = Functions.GetCurrentDrawable;
        return JNI.callP(__functionAddress);
    }

    public static void glXWaitGL() {
        long __functionAddress = Functions.WaitGL;
        JNI.callV(__functionAddress);
    }

    public static void glXWaitX() {
        long __functionAddress = Functions.WaitX;
        JNI.callV(__functionAddress);
    }

    public static void glXSwapBuffers(long display, long draw) {
        long __functionAddress = Functions.SwapBuffers;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(draw);
        }
        JNI.callPPV(__functionAddress, display, draw);
    }

    public static void glXUseXFont(long font, int first, int count, int list_base) {
        long __functionAddress = Functions.UseXFont;
        JNI.callPV(__functionAddress, font, first, count, list_base);
    }

    public static long nglXCreateGLXPixmap(long display, long visual, long pixmap) {
        long __functionAddress = Functions.CreateGLXPixmap;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            XVisualInfo.validate(visual);
        }
        return JNI.callPPPP(__functionAddress, display, visual, pixmap);
    }

    public static long glXCreateGLXPixmap(long display, XVisualInfo visual, long pixmap) {
        return GLX.nglXCreateGLXPixmap(display, visual.address(), pixmap);
    }

    public static void glXDestroyGLXPixmap(long display, long pixmap) {
        long __functionAddress = Functions.DestroyGLXPixmap;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(pixmap);
        }
        JNI.callPPV(__functionAddress, display, pixmap);
    }

    public static int glXQueryExtension(long display, int[] error_base, int[] event_base) {
        long __functionAddress = Functions.QueryExtension;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer(error_base, 1);
            Checks.checkBuffer(event_base, 1);
        }
        return JNI.callPPPI(__functionAddress, display, error_base, event_base);
    }

    public static int glXQueryVersion(long display, int[] major, int[] minor) {
        long __functionAddress = Functions.QueryVersion;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer(major, 1);
            Checks.checkBuffer(minor, 1);
        }
        return JNI.callPPPI(__functionAddress, display, major, minor);
    }

    public static int glXGetConfig(long display, XVisualInfo visual, int attribute, int[] value) {
        long __functionAddress = Functions.GetConfig;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer(value, 1);
            XVisualInfo.validate(visual.address());
        }
        return JNI.callPPPI(__functionAddress, display, visual.address(), attribute, value);
    }

    public static XVisualInfo glXChooseVisual(long display, int screen, int[] attrib_list) {
        long __functionAddress = Functions.ChooseVisual;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list);
            }
        }
        long __result = JNI.callPPP(__functionAddress, display, screen, attrib_list);
        return XVisualInfo.create(__result);
    }

    public static final class Functions {
        public static final long QueryExtension = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXQueryExtension");
        public static final long QueryVersion = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXQueryVersion");
        public static final long GetConfig = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXGetConfig");
        public static final long ChooseVisual = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXChooseVisual");
        public static final long CreateContext = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXCreateContext");
        public static final long MakeCurrent = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXMakeCurrent");
        public static final long CopyContext = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXCopyContext");
        public static final long IsDirect = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXIsDirect");
        public static final long DestroyContext = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXDestroyContext");
        public static final long GetCurrentContext = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXGetCurrentContext");
        public static final long GetCurrentDrawable = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXGetCurrentDrawable");
        public static final long WaitGL = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXWaitGL");
        public static final long WaitX = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXWaitX");
        public static final long SwapBuffers = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXSwapBuffers");
        public static final long UseXFont = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXUseXFont");
        public static final long CreateGLXPixmap = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXCreateGLXPixmap");
        public static final long DestroyGLXPixmap = APIUtil.apiGetFunctionAddress(GL.getFunctionProvider(), "glXDestroyGLXPixmap");

        private Functions() {
        }
    }
}

