/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class ARBShaderObjects {
    public static final int GL_PROGRAM_OBJECT_ARB = 35648;
    public static final int GL_OBJECT_TYPE_ARB = 35662;
    public static final int GL_OBJECT_SUBTYPE_ARB = 35663;
    public static final int GL_OBJECT_DELETE_STATUS_ARB = 35712;
    public static final int GL_OBJECT_COMPILE_STATUS_ARB = 35713;
    public static final int GL_OBJECT_LINK_STATUS_ARB = 35714;
    public static final int GL_OBJECT_VALIDATE_STATUS_ARB = 35715;
    public static final int GL_OBJECT_INFO_LOG_LENGTH_ARB = 35716;
    public static final int GL_OBJECT_ATTACHED_OBJECTS_ARB = 35717;
    public static final int GL_OBJECT_ACTIVE_UNIFORMS_ARB = 35718;
    public static final int GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 35719;
    public static final int GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 35720;
    public static final int GL_SHADER_OBJECT_ARB = 35656;
    public static final int GL_FLOAT_VEC2_ARB = 35664;
    public static final int GL_FLOAT_VEC3_ARB = 35665;
    public static final int GL_FLOAT_VEC4_ARB = 35666;
    public static final int GL_INT_VEC2_ARB = 35667;
    public static final int GL_INT_VEC3_ARB = 35668;
    public static final int GL_INT_VEC4_ARB = 35669;
    public static final int GL_BOOL_ARB = 35670;
    public static final int GL_BOOL_VEC2_ARB = 35671;
    public static final int GL_BOOL_VEC3_ARB = 35672;
    public static final int GL_BOOL_VEC4_ARB = 35673;
    public static final int GL_FLOAT_MAT2_ARB = 35674;
    public static final int GL_FLOAT_MAT3_ARB = 35675;
    public static final int GL_FLOAT_MAT4_ARB = 35676;
    public static final int GL_SAMPLER_1D_ARB = 35677;
    public static final int GL_SAMPLER_2D_ARB = 35678;
    public static final int GL_SAMPLER_3D_ARB = 35679;
    public static final int GL_SAMPLER_CUBE_ARB = 35680;
    public static final int GL_SAMPLER_1D_SHADOW_ARB = 35681;
    public static final int GL_SAMPLER_2D_SHADOW_ARB = 35682;
    public static final int GL_SAMPLER_2D_RECT_ARB = 35683;
    public static final int GL_SAMPLER_2D_RECT_SHADOW_ARB = 35684;

    protected ARBShaderObjects() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glDeleteObjectARB, caps.glGetHandleARB, caps.glDetachObjectARB, caps.glCreateShaderObjectARB, caps.glShaderSourceARB, caps.glCompileShaderARB, caps.glCreateProgramObjectARB, caps.glAttachObjectARB, caps.glLinkProgramARB, caps.glUseProgramObjectARB, caps.glValidateProgramARB, caps.glUniform1fARB, caps.glUniform2fARB, caps.glUniform3fARB, caps.glUniform4fARB, caps.glUniform1iARB, caps.glUniform2iARB, caps.glUniform3iARB, caps.glUniform4iARB, caps.glUniform1fvARB, caps.glUniform2fvARB, caps.glUniform3fvARB, caps.glUniform4fvARB, caps.glUniform1ivARB, caps.glUniform2ivARB, caps.glUniform3ivARB, caps.glUniform4ivARB, caps.glUniformMatrix2fvARB, caps.glUniformMatrix3fvARB, caps.glUniformMatrix4fvARB, caps.glGetObjectParameterfvARB, caps.glGetObjectParameterivARB, caps.glGetInfoLogARB, caps.glGetAttachedObjectsARB, caps.glGetUniformLocationARB, caps.glGetActiveUniformARB, caps.glGetUniformfvARB, caps.glGetUniformivARB, caps.glGetShaderSourceARB);
    }

    public static void glDeleteObjectARB(int obj) {
        long __functionAddress = GL.getCapabilities().glDeleteObjectARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, obj);
    }

    public static int glGetHandleARB(int pname) {
        long __functionAddress = GL.getCapabilities().glGetHandleARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress, pname);
    }

    public static void glDetachObjectARB(int containerObj, int attachedObj) {
        long __functionAddress = GL.getCapabilities().glDetachObjectARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, containerObj, attachedObj);
    }

    public static int glCreateShaderObjectARB(int shaderType) {
        long __functionAddress = GL.getCapabilities().glCreateShaderObjectARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress, shaderType);
    }

    public static void nglShaderSourceARB(int shaderObj, int count, long string, long length) {
        long __functionAddress = GL.getCapabilities().glShaderSourceARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, shaderObj, count, string, length);
    }

    public static void glShaderSourceARB(int shaderObj, PointerBuffer string, IntBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, string.remaining());
        }
        ARBShaderObjects.nglShaderSourceARB(shaderObj, string.remaining(), MemoryUtil.memAddress(string), MemoryUtil.memAddressSafe(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSourceARB(int shaderObj, CharSequence ... string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringAddress = APIUtil.apiArrayUTF8i(stack, string);
            ARBShaderObjects.nglShaderSourceARB(shaderObj, string.length, stringAddress, stringAddress - (long)(string.length << 2));
            APIUtil.apiArrayFree(stringAddress, string.length);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSourceARB(int shaderObj, CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringAddress = APIUtil.apiArrayUTF8i(stack, string);
            ARBShaderObjects.nglShaderSourceARB(shaderObj, 1, stringAddress, stringAddress - 4L);
            APIUtil.apiArrayFree(stringAddress, 1);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glCompileShaderARB(int shaderObj) {
        long __functionAddress = GL.getCapabilities().glCompileShaderARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, shaderObj);
    }

    public static int glCreateProgramObjectARB() {
        long __functionAddress = GL.getCapabilities().glCreateProgramObjectARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static void glAttachObjectARB(int containerObj, int obj) {
        long __functionAddress = GL.getCapabilities().glAttachObjectARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, containerObj, obj);
    }

    public static void glLinkProgramARB(int programObj) {
        long __functionAddress = GL.getCapabilities().glLinkProgramARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, programObj);
    }

    public static void glUseProgramObjectARB(int programObj) {
        long __functionAddress = GL.getCapabilities().glUseProgramObjectARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, programObj);
    }

    public static void glValidateProgramARB(int programObj) {
        long __functionAddress = GL.getCapabilities().glValidateProgramARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, programObj);
    }

    public static void glUniform1fARB(int location, float v0) {
        long __functionAddress = GL.getCapabilities().glUniform1fARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0);
    }

    public static void glUniform2fARB(int location, float v0, float v1) {
        long __functionAddress = GL.getCapabilities().glUniform2fARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0, v1);
    }

    public static void glUniform3fARB(int location, float v0, float v1, float v2) {
        long __functionAddress = GL.getCapabilities().glUniform3fARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0, v1, v2);
    }

    public static void glUniform4fARB(int location, float v0, float v1, float v2, float v3) {
        long __functionAddress = GL.getCapabilities().glUniform4fARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void glUniform1iARB(int location, int v0) {
        long __functionAddress = GL.getCapabilities().glUniform1iARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0);
    }

    public static void glUniform2iARB(int location, int v0, int v1) {
        long __functionAddress = GL.getCapabilities().glUniform2iARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0, v1);
    }

    public static void glUniform3iARB(int location, int v0, int v1, int v2) {
        long __functionAddress = GL.getCapabilities().glUniform3iARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0, v1, v2);
    }

    public static void glUniform4iARB(int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GL.getCapabilities().glUniform4iARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void nglUniform1fvARB(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform1fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform1fvARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform1fvARB(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglUniform2fvARB(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform2fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform2fvARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform2fvARB(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglUniform3fvARB(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform3fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform3fvARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform3fvARB(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglUniform4fvARB(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform4fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform4fvARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform4fvARB(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglUniform1ivARB(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform1ivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform1ivARB(int location, IntBuffer value) {
        ARBShaderObjects.nglUniform1ivARB(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglUniform2ivARB(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform2ivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform2ivARB(int location, IntBuffer value) {
        ARBShaderObjects.nglUniform2ivARB(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglUniform3ivARB(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform3ivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform3ivARB(int location, IntBuffer value) {
        ARBShaderObjects.nglUniform3ivARB(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglUniform4ivARB(int location, int count, long value) {
        long __functionAddress = GL.getCapabilities().glUniform4ivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, value);
    }

    public static void glUniform4ivARB(int location, IntBuffer value) {
        ARBShaderObjects.nglUniform4ivARB(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2fvARB(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2fvARB(int location, boolean transpose, FloatBuffer value) {
        ARBShaderObjects.nglUniformMatrix2fvARB(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3fvARB(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3fvARB(int location, boolean transpose, FloatBuffer value) {
        ARBShaderObjects.nglUniformMatrix3fvARB(location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4fvARB(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4fvARB(int location, boolean transpose, FloatBuffer value) {
        ARBShaderObjects.nglUniformMatrix4fvARB(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglGetObjectParameterfvARB(int obj, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetObjectParameterfvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, obj, pname, params);
    }

    public static void glGetObjectParameterfvARB(int obj, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderObjects.nglGetObjectParameterfvARB(obj, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetObjectParameterivARB(int obj, int pname, long params) {
        long __functionAddress = GL.getCapabilities().glGetObjectParameterivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, obj, pname, params);
    }

    public static void glGetObjectParameterivARB(int obj, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetObjectParameteriARB(int obj, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetInfoLogARB(int obj, int maxLength, long length, long infoLog) {
        long __functionAddress = GL.getCapabilities().glGetInfoLogARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, obj, maxLength, length, infoLog);
    }

    public static void glGetInfoLogARB(int obj, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBShaderObjects.nglGetInfoLogARB(obj, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetInfoLogARB(int obj, int maxLength) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(maxLength);
        try {
            IntBuffer length = stack.ints(0);
            ARBShaderObjects.nglGetInfoLogARB(obj, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetInfoLogARB(int obj) {
        int maxLength = ARBShaderObjects.glGetObjectParameteriARB(obj, 35716);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(maxLength);
        try {
            IntBuffer length = stack.ints(0);
            ARBShaderObjects.nglGetInfoLogARB(obj, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetAttachedObjectsARB(int containerObj, int maxCount, long count, long obj) {
        long __functionAddress = GL.getCapabilities().glGetAttachedObjectsARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, containerObj, maxCount, count, obj);
    }

    public static void glGetAttachedObjectsARB(int containerObj, IntBuffer count, IntBuffer obj) {
        if (Checks.CHECKS && count != null) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, obj.remaining(), MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(obj));
    }

    public static int nglGetUniformLocationARB(int programObj, long name) {
        long __functionAddress = GL.getCapabilities().glGetUniformLocationARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, programObj, name);
    }

    public static int glGetUniformLocationARB(int programObj, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBShaderObjects.nglGetUniformLocationARB(programObj, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformLocationARB(int programObj, CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.UTF8(name);
            int n = ARBShaderObjects.nglGetUniformLocationARB(programObj, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetActiveUniformARB(int programObj, int index, int maxLength, long length, long size, long type, long name) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPPV(__functionAddress, programObj, index, maxLength, length, size, type, name);
    }

    public static void glGetActiveUniformARB(int programObj, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniformARB(int programObj, int index, int maxLength, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(maxLength);
            ARBShaderObjects.nglGetActiveUniformARB(programObj, index, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memUTF8(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetActiveUniformARB(int programObj, int index, IntBuffer size, IntBuffer type) {
        int maxLength = ARBShaderObjects.glGetObjectParameteriARB(programObj, 35719);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(maxLength);
            ARBShaderObjects.nglGetActiveUniformARB(programObj, index, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memUTF8(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetUniformfvARB(int programObj, int location, long params) {
        long __functionAddress = GL.getCapabilities().glGetUniformfvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, programObj, location, params);
    }

    public static void glGetUniformfvARB(int programObj, int location, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderObjects.nglGetUniformfvARB(programObj, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float glGetUniformfARB(int programObj, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            FloatBuffer params = stack.callocFloat(1);
            ARBShaderObjects.nglGetUniformfvARB(programObj, location, MemoryUtil.memAddress(params));
            float f = params.get(0);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetUniformivARB(int programObj, int location, long params) {
        long __functionAddress = GL.getCapabilities().glGetUniformivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, programObj, location, params);
    }

    public static void glGetUniformivARB(int programObj, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderObjects.nglGetUniformivARB(programObj, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetUniformiARB(int programObj, int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBShaderObjects.nglGetUniformivARB(programObj, location, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetShaderSourceARB(int obj, int maxLength, long length, long source) {
        long __functionAddress = GL.getCapabilities().glGetShaderSourceARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, obj, maxLength, length, source);
    }

    public static void glGetShaderSourceARB(int obj, IntBuffer length, ByteBuffer source) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBShaderObjects.nglGetShaderSourceARB(obj, source.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderSourceARB(int obj, int maxLength) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc(maxLength);
        try {
            IntBuffer length = stack.ints(0);
            ARBShaderObjects.nglGetShaderSourceARB(obj, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(source));
            String string = MemoryUtil.memUTF8(source, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(source);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetShaderSourceARB(int obj) {
        int maxLength = ARBShaderObjects.glGetObjectParameteriARB(obj, 35720);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer source = MemoryUtil.memAlloc(maxLength);
        try {
            IntBuffer length = stack.ints(0);
            ARBShaderObjects.nglGetShaderSourceARB(obj, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(source));
            String string = MemoryUtil.memUTF8(source, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(source);
            stack.setPointer(stackPointer);
        }
    }

    public static void glShaderSourceARB(int shaderObj, PointerBuffer string, int[] length) {
        long __functionAddress = GL.getCapabilities().glShaderSourceARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, string.remaining());
            }
        }
        JNI.callPPV(__functionAddress, shaderObj, string.remaining(), MemoryUtil.memAddress(string), length);
    }

    public static void glUniform1fvARB(int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniform1fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length, value);
    }

    public static void glUniform2fvARB(int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniform2fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 1, value);
    }

    public static void glUniform3fvARB(int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniform3fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 3, value);
    }

    public static void glUniform4fvARB(int location, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniform4fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 2, value);
    }

    public static void glUniform1ivARB(int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glUniform1ivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length, value);
    }

    public static void glUniform2ivARB(int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glUniform2ivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 1, value);
    }

    public static void glUniform3ivARB(int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glUniform3ivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 3, value);
    }

    public static void glUniform4ivARB(int location, int[] value) {
        long __functionAddress = GL.getCapabilities().glUniform4ivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 2, value);
    }

    public static void glUniformMatrix2fvARB(int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix2fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 2, transpose, value);
    }

    public static void glUniformMatrix3fvARB(int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix3fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length / 9, transpose, value);
    }

    public static void glUniformMatrix4fvARB(int location, boolean transpose, float[] value) {
        long __functionAddress = GL.getCapabilities().glUniformMatrix4fvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, location, value.length >> 4, transpose, value);
    }

    public static void glGetObjectParameterfvARB(int obj, int pname, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetObjectParameterfvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, obj, pname, params);
    }

    public static void glGetObjectParameterivARB(int obj, int pname, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetObjectParameterivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, obj, pname, params);
    }

    public static void glGetInfoLogARB(int obj, int[] length, ByteBuffer infoLog) {
        long __functionAddress = GL.getCapabilities().glGetInfoLogARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, obj, infoLog.remaining(), length, MemoryUtil.memAddress(infoLog));
    }

    public static void glGetAttachedObjectsARB(int containerObj, int[] count, int[] obj) {
        long __functionAddress = GL.getCapabilities().glGetAttachedObjectsARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (count != null) {
                Checks.checkBuffer(count, 1);
            }
        }
        JNI.callPPV(__functionAddress, containerObj, obj.length, count, obj);
    }

    public static void glGetActiveUniformARB(int programObj, int index, int[] length, int[] size, int[] type, ByteBuffer name) {
        long __functionAddress = GL.getCapabilities().glGetActiveUniformARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
            Checks.checkBuffer(size, 1);
            Checks.checkBuffer(type, 1);
        }
        JNI.callPPPPV(__functionAddress, programObj, index, name.remaining(), length, size, type, MemoryUtil.memAddress(name));
    }

    public static void glGetUniformfvARB(int programObj, int location, float[] params) {
        long __functionAddress = GL.getCapabilities().glGetUniformfvARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, programObj, location, params);
    }

    public static void glGetUniformivARB(int programObj, int location, int[] params) {
        long __functionAddress = GL.getCapabilities().glGetUniformivARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, programObj, location, params);
    }

    public static void glGetShaderSourceARB(int obj, int[] length, ByteBuffer source) {
        long __functionAddress = GL.getCapabilities().glGetShaderSourceARB;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, obj, source.remaining(), length, MemoryUtil.memAddress(source));
    }
}

