/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NVGLUFramebuffer
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FBO;
    public static final int RBO;
    public static final int TEXTURE;
    public static final int IMAGE;

    NVGLUFramebuffer(long address, ByteBuffer container) {
        super(address, container);
    }

    public NVGLUFramebuffer(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NVGLUFramebuffer.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int fbo() {
        return NVGLUFramebuffer.nfbo(this.address());
    }

    public int rbo() {
        return NVGLUFramebuffer.nrbo(this.address());
    }

    public int texture() {
        return NVGLUFramebuffer.ntexture(this.address());
    }

    public int image() {
        return NVGLUFramebuffer.nimage(this.address());
    }

    public static NVGLUFramebuffer malloc() {
        return NVGLUFramebuffer.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NVGLUFramebuffer calloc() {
        return NVGLUFramebuffer.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NVGLUFramebuffer create() {
        return new NVGLUFramebuffer(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NVGLUFramebuffer create(long address) {
        return address == 0L ? null : new NVGLUFramebuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NVGLUFramebuffer.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NVGLUFramebuffer.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NVGLUFramebuffer mallocStack() {
        return NVGLUFramebuffer.mallocStack(MemoryStack.stackGet());
    }

    public static NVGLUFramebuffer callocStack() {
        return NVGLUFramebuffer.callocStack(MemoryStack.stackGet());
    }

    public static NVGLUFramebuffer mallocStack(MemoryStack stack) {
        return NVGLUFramebuffer.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NVGLUFramebuffer callocStack(MemoryStack stack) {
        return NVGLUFramebuffer.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NVGLUFramebuffer.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NVGLUFramebuffer.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NVGLUFramebuffer.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NVGLUFramebuffer.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nfbo(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FBO);
    }

    public static int nrbo(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RBO);
    }

    public static int ntexture(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TEXTURE);
    }

    public static int nimage(long struct) {
        return MemoryUtil.memGetInt(struct + (long)IMAGE);
    }

    static {
        Struct.Layout layout = NVGLUFramebuffer.__struct(NVGLUFramebuffer.__member(4), NVGLUFramebuffer.__member(4), NVGLUFramebuffer.__member(4), NVGLUFramebuffer.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FBO = layout.offsetof(0);
        RBO = layout.offsetof(1);
        TEXTURE = layout.offsetof(2);
        IMAGE = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<NVGLUFramebuffer, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NVGLUFramebuffer newInstance(long address) {
            return new NVGLUFramebuffer(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int fbo() {
            return NVGLUFramebuffer.nfbo(this.address());
        }

        public int rbo() {
            return NVGLUFramebuffer.nrbo(this.address());
        }

        public int texture() {
            return NVGLUFramebuffer.ntexture(this.address());
        }

        public int image() {
            return NVGLUFramebuffer.nimage(this.address());
        }
    }
}

