/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVNativeQuery {
    protected NVNativeQuery() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglQueryNativeDisplayNV, caps.eglQueryNativeWindowNV, caps.eglQueryNativePixmapNV);
    }

    public static int neglQueryNativeDisplayNV(long dpy, long display_id) {
        long __functionAddress = EGL.getCapabilities().eglQueryNativeDisplayNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPI(__functionAddress, dpy, display_id);
    }

    public static int eglQueryNativeDisplayNV(long dpy, PointerBuffer display_id) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(display_id, 1);
        }
        return NVNativeQuery.neglQueryNativeDisplayNV(dpy, MemoryUtil.memAddress(display_id));
    }

    public static int neglQueryNativeWindowNV(long dpy, long surf, long window) {
        long __functionAddress = EGL.getCapabilities().eglQueryNativeWindowNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(surf);
        }
        return JNI.callPPPI(__functionAddress, dpy, surf, window);
    }

    public static int eglQueryNativeWindowNV(long dpy, long surf, PointerBuffer window) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(window, 1);
        }
        return NVNativeQuery.neglQueryNativeWindowNV(dpy, surf, MemoryUtil.memAddress(window));
    }

    public static int neglQueryNativePixmapNV(long dpy, long surf, long pixmap) {
        long __functionAddress = EGL.getCapabilities().eglQueryNativePixmapNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(surf);
        }
        return JNI.callPPPI(__functionAddress, dpy, surf, pixmap);
    }

    public static int eglQueryNativePixmapNV(long dpy, long surf, PointerBuffer pixmap) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(pixmap, 1);
        }
        return NVNativeQuery.neglQueryNativePixmapNV(dpy, surf, MemoryUtil.memAddress(pixmap));
    }
}

