/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class MESAImageDMABufExport {
    protected MESAImageDMABufExport() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglExportDMABUFImageQueryMESA, caps.eglExportDMABUFImageMESA);
    }

    public static int neglExportDMABUFImageQueryMESA(long dpy, long image, long fourcc, long num_planes, long modifiers) {
        long __functionAddress = EGL.getCapabilities().eglExportDMABUFImageQueryMESA;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(image);
        }
        return JNI.callPPPPPI(__functionAddress, dpy, image, fourcc, num_planes, modifiers);
    }

    public static int eglExportDMABUFImageQueryMESA(long dpy, long image, IntBuffer fourcc, IntBuffer num_planes, LongBuffer modifiers) {
        if (Checks.CHECKS) {
            if (fourcc != null) {
                Checks.checkBuffer((Buffer)fourcc, 1);
            }
            if (num_planes != null) {
                Checks.checkBuffer((Buffer)num_planes, 1);
            }
            if (modifiers != null) {
                Checks.checkBuffer((Buffer)modifiers, 1);
            }
        }
        return MESAImageDMABufExport.neglExportDMABUFImageQueryMESA(dpy, image, MemoryUtil.memAddressSafe(fourcc), MemoryUtil.memAddressSafe(num_planes), MemoryUtil.memAddressSafe(modifiers));
    }

    public static int neglExportDMABUFImageMESA(long dpy, long image, long fds, long strides, long offsets) {
        long __functionAddress = EGL.getCapabilities().eglExportDMABUFImageMESA;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(image);
        }
        return JNI.callPPPPPI(__functionAddress, dpy, image, fds, strides, offsets);
    }

    public static int eglExportDMABUFImageMESA(long dpy, long image, IntBuffer fds, IntBuffer strides, IntBuffer offsets) {
        if (Checks.CHECKS) {
            if (fds != null) {
                Checks.checkBuffer((Buffer)fds, 1);
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, 1);
            }
            if (offsets != null) {
                Checks.checkBuffer((Buffer)offsets, 1);
            }
        }
        return MESAImageDMABufExport.neglExportDMABUFImageMESA(dpy, image, MemoryUtil.memAddressSafe(fds), MemoryUtil.memAddressSafe(strides), MemoryUtil.memAddressSafe(offsets));
    }

    public static int eglExportDMABUFImageQueryMESA(long dpy, long image, int[] fourcc, int[] num_planes, long[] modifiers) {
        long __functionAddress = EGL.getCapabilities().eglExportDMABUFImageQueryMESA;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(image);
            if (fourcc != null) {
                Checks.checkBuffer(fourcc, 1);
            }
            if (num_planes != null) {
                Checks.checkBuffer(num_planes, 1);
            }
            if (modifiers != null) {
                Checks.checkBuffer(modifiers, 1);
            }
        }
        return JNI.callPPPPPI(__functionAddress, dpy, image, fourcc, num_planes, modifiers);
    }

    public static int eglExportDMABUFImageMESA(long dpy, long image, int[] fds, int[] strides, int[] offsets) {
        long __functionAddress = EGL.getCapabilities().eglExportDMABUFImageMESA;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(image);
            if (fds != null) {
                Checks.checkBuffer(fds, 1);
            }
            if (strides != null) {
                Checks.checkBuffer(strides, 1);
            }
            if (offsets != null) {
                Checks.checkBuffer(offsets, 1);
            }
        }
        return JNI.callPPPPPI(__functionAddress, dpy, image, fds, strides, offsets);
    }
}

