/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRFenceSync {
    public static final int EGL_SYNC_PRIOR_COMMANDS_COMPLETE_KHR = 12528;
    public static final int EGL_SYNC_CONDITION_KHR = 12536;
    public static final int EGL_SYNC_FENCE_KHR = 12537;

    protected KHRFenceSync() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglCreateSyncKHR, caps.eglDestroySyncKHR, caps.eglClientWaitSyncKHR, caps.eglGetSyncAttribKHR);
    }

    public static long neglCreateSyncKHR(long dpy, int type, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPPP(__functionAddress, dpy, type, attrib_list);
    }

    public static long eglCreateSyncKHR(long dpy, int type, IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNT(attrib_list, 12344);
        }
        return KHRFenceSync.neglCreateSyncKHR(dpy, type, MemoryUtil.memAddress(attrib_list));
    }

    public static int eglDestroySyncKHR(long dpy, long sync) {
        long __functionAddress = EGL.getCapabilities().eglDestroySyncKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPI(__functionAddress, dpy, sync);
    }

    public static int eglClientWaitSyncKHR(long dpy, long sync, int flags, long timeout) {
        long __functionAddress = EGL.getCapabilities().eglClientWaitSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPJI(__functionAddress, dpy, sync, flags, timeout);
    }

    public static int neglGetSyncAttribKHR(long dpy, long sync, int attribute, long value) {
        long __functionAddress = EGL.getCapabilities().eglGetSyncAttribKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPPI(__functionAddress, dpy, sync, attribute, value);
    }

    public static int eglGetSyncAttribKHR(long dpy, long sync, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return KHRFenceSync.neglGetSyncAttribKHR(dpy, sync, attribute, MemoryUtil.memAddress(value));
    }

    public static long eglCreateSyncKHR(long dpy, int type, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreateSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkNT(attrib_list, 12344);
        }
        return JNI.callPPP(__functionAddress, dpy, type, attrib_list);
    }

    public static int eglGetSyncAttribKHR(long dpy, long sync, int attribute, int[] value) {
        long __functionAddress = EGL.getCapabilities().eglGetSyncAttribKHR;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
            Checks.checkBuffer(value, 1);
        }
        return JNI.callPPPI(__functionAddress, dpy, sync, attribute, value);
    }
}

