/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EGL12 {
    public static final int EGL_ALPHA_FORMAT = 12424;
    public static final int EGL_ALPHA_FORMAT_NONPRE = 12427;
    public static final int EGL_ALPHA_FORMAT_PRE = 12428;
    public static final int EGL_ALPHA_MASK_SIZE = 12350;
    public static final int EGL_BUFFER_PRESERVED = 12436;
    public static final int EGL_BUFFER_DESTROYED = 12437;
    public static final int EGL_CLIENT_APIS = 12429;
    public static final int EGL_COLORSPACE = 12423;
    public static final int EGL_COLORSPACE_sRGB = 12425;
    public static final int EGL_COLORSPACE_LINEAR = 12426;
    public static final int EGL_COLOR_BUFFER_TYPE = 12351;
    public static final int EGL_CONTEXT_CLIENT_TYPE = 12439;
    public static final int EGL_DISPLAY_SCALING = 10000;
    public static final int EGL_HORIZONTAL_RESOLUTION = 12432;
    public static final int EGL_LUMINANCE_BUFFER = 12431;
    public static final int EGL_LUMINANCE_SIZE = 12349;
    public static final int EGL_OPENGL_ES_BIT = 1;
    public static final int EGL_OPENVG_BIT = 2;
    public static final int EGL_OPENGL_ES_API = 12448;
    public static final int EGL_OPENVG_API = 12449;
    public static final int EGL_OPENVG_IMAGE = 12438;
    public static final int EGL_PIXEL_ASPECT_RATIO = 12434;
    public static final int EGL_RENDERABLE_TYPE = 12352;
    public static final int EGL_RENDER_BUFFER = 12422;
    public static final int EGL_RGB_BUFFER = 12430;
    public static final int EGL_SINGLE_BUFFER = 12421;
    public static final int EGL_SWAP_BEHAVIOR = 12435;
    public static final int EGL_UNKNOWN = -1;
    public static final int EGL_VERTICAL_RESOLUTION = 12433;

    protected EGL12() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglBindAPI, caps.eglQueryAPI, caps.eglCreatePbufferFromClientBuffer, caps.eglReleaseThread, caps.eglWaitClient);
    }

    public static int eglBindAPI(int api) {
        long __functionAddress = EGL.getCapabilities().eglBindAPI;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress, api);
    }

    public static int eglQueryAPI() {
        long __functionAddress = EGL.getCapabilities().eglQueryAPI;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static long neglCreatePbufferFromClientBuffer(long dpy, int buftype, long buffer, long config, long attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePbufferFromClientBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(buffer);
            Checks.checkPointer(config);
        }
        return JNI.callPPPPP(__functionAddress, dpy, buftype, buffer, config, attrib_list);
    }

    public static long eglCreatePbufferFromClientBuffer(long dpy, int buftype, long buffer, long config, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EGL12.neglCreatePbufferFromClientBuffer(dpy, buftype, buffer, config, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static int eglReleaseThread() {
        long __functionAddress = EGL.getCapabilities().eglReleaseThread;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static int eglWaitClient() {
        long __functionAddress = EGL.getCapabilities().eglWaitClient;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callI(__functionAddress);
    }

    public static long eglCreatePbufferFromClientBuffer(long dpy, int buftype, long buffer, long config, int[] attrib_list) {
        long __functionAddress = EGL.getCapabilities().eglCreatePbufferFromClientBuffer;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(buffer);
            Checks.checkPointer(config);
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344);
            }
        }
        return JNI.callPPPPP(__functionAddress, dpy, buftype, buffer, config, attrib_list);
    }
}

