/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;

public class EGL11 {
    public static final int EGL_BACK_BUFFER = 12420;
    public static final int EGL_BIND_TO_TEXTURE_RGB = 12345;
    public static final int EGL_BIND_TO_TEXTURE_RGBA = 12346;
    public static final int EGL_CONTEXT_LOST = 12302;
    public static final int EGL_MIN_SWAP_INTERVAL = 12347;
    public static final int EGL_MAX_SWAP_INTERVAL = 12348;
    public static final int EGL_MIPMAP_TEXTURE = 12418;
    public static final int EGL_MIPMAP_LEVEL = 12419;
    public static final int EGL_NO_TEXTURE = 12380;
    public static final int EGL_TEXTURE_2D = 12383;
    public static final int EGL_TEXTURE_FORMAT = 12416;
    public static final int EGL_TEXTURE_RGB = 12381;
    public static final int EGL_TEXTURE_RGBA = 12382;
    public static final int EGL_TEXTURE_TARGET = 12417;

    protected EGL11() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(EGLCapabilities caps) {
        return Checks.checkFunctions(caps.eglBindTexImage, caps.eglReleaseTexImage, caps.eglSurfaceAttrib, caps.eglSwapInterval);
    }

    public static int eglBindTexImage(long dpy, long surface, int buffer) {
        long __functionAddress = EGL.getCapabilities().eglBindTexImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPI(__functionAddress, dpy, surface, buffer);
    }

    public static int eglReleaseTexImage(long dpy, long surface, int buffer) {
        long __functionAddress = EGL.getCapabilities().eglReleaseTexImage;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPI(__functionAddress, dpy, surface, buffer);
    }

    public static int eglSurfaceAttrib(long dpy, long surface, int attribute, int value) {
        long __functionAddress = EGL.getCapabilities().eglSurfaceAttrib;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPI(__functionAddress, dpy, surface, attribute, value);
    }

    public static int eglSwapInterval(long dpy, int interval) {
        long __functionAddress = EGL.getCapabilities().eglSwapInterval;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dpy);
        }
        return JNI.callPI(__functionAddress, dpy, interval);
    }
}

