/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.lwjgl.egl.EGL10;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.egl.EGLException;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public final class EGL {
    private static FunctionProvider functionProvider;
    private static EGLCapabilities caps;

    private EGL() {
    }

    public static void create() {
        SharedLibrary EGL2;
        switch (Platform.get()) {
            case LINUX: {
                EGL2 = Library.loadNative(Configuration.EGL_LIBRARY_NAME, "libEGL.so.1");
                break;
            }
            case MACOSX: {
                EGL2 = Library.loadNative(Configuration.EGL_LIBRARY_NAME, "EGL");
                break;
            }
            case WINDOWS: {
                EGL2 = Library.loadNative(Configuration.EGL_LIBRARY_NAME, "libEGL", "EGL");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        EGL.create(EGL2);
    }

    public static void create(String libName) {
        EGL.create(Library.loadNative(libName));
    }

    private static void create(SharedLibrary EGL2) {
        try {
            EGL.create((FunctionProvider)new SharedLibrary.Delegate(EGL2){
                private final long eglGetProcAddress;
                {
                    this.eglGetProcAddress = this.library.getFunctionAddress("eglGetProcAddress");
                    if (this.eglGetProcAddress == 0L) {
                        throw new EGLException("A core EGL function is missing. Make sure that EGL is available.");
                    }
                }

                @Override
                public long getFunctionAddress(ByteBuffer functionName) {
                    long address = JNI.invokePP(this.eglGetProcAddress, MemoryUtil.memAddress(functionName));
                    if (address == 0L && (address = this.library.getFunctionAddress(functionName)) == 0L && Checks.DEBUG_FUNCTIONS) {
                        APIUtil.apiLog("Failed to locate address for EGL function " + MemoryUtil.memASCII(functionName));
                    }
                    return address;
                }
            });
        }
        catch (RuntimeException e) {
            EGL2.free();
            throw e;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (EGL.functionProvider != null) {
            throw new IllegalStateException("EGL has already been created.");
        }
        EGL.functionProvider = functionProvider;
        caps = EGL.createClientCapabilities();
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        caps = null;
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
    }

    public static FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    public static EGLCapabilities getCapabilities() {
        return caps;
    }

    private static EGLCapabilities createClientCapabilities() {
        long QueryString = functionProvider.getFunctionAddress("eglQueryString");
        long versionString = JNI.invokePP(QueryString, 0L, 12372);
        HashSet<String> ext = new HashSet<String>(32);
        if (versionString == 0L) {
            JNI.invokeI(functionProvider.getFunctionAddress("eglGetError"));
        } else {
            APIUtil.APIVersion version = APIUtil.apiParseVersion(MemoryUtil.memASCII(versionString), "EGL");
            EGL.addEGLVersions(version.major, version.minor, ext);
            EGL.addExtensions(MemoryUtil.memASCII(JNI.invokePP(QueryString, 0L, 12373)), ext);
        }
        return new EGLCapabilities(functionProvider, ext);
    }

    public static EGLCapabilities createDisplayCapabilities(long dpy, int majorVersion, int minorVersion) {
        HashSet<String> supportedExtensions = new HashSet<String>(32);
        EGL.addEGLVersions(majorVersion, minorVersion, supportedExtensions);
        EGL.addExtensions(EGL10.eglQueryString(dpy, 12373), supportedExtensions);
        return new EGLCapabilities(functionProvider, supportedExtensions);
    }

    private static void addEGLVersions(int MAJOR, int MINOR, Set<String> supportedExtensions) {
        int[][] versions = new int[][]{{0, 1, 2, 3, 4, 5}};
        block0: for (int major = 1; major <= Math.min(MAJOR, versions.length); ++major) {
            for (int minor : versions[major - 1]) {
                if (major == MAJOR && MINOR < minor) continue block0;
                supportedExtensions.add(String.format("EGL%d%d%s", major, minor, ""));
            }
        }
    }

    private static void addExtensions(String extensionsString, Set<String> supportedExtensions) {
        StringTokenizer tokenizer = new StringTokenizer(extensionsString);
        while (tokenizer.hasMoreTokens()) {
            supportedExtensions.add(tokenizer.nextToken());
        }
    }

    static boolean checkExtension(String extension, boolean supported) {
        if (supported) {
            return true;
        }
        APIUtil.apiLog("[EGL] " + extension + " was reported as available but an entry point is missing.");
        return false;
    }

    static {
        if (!Configuration.EGL_EXPLICIT_INIT.get(false).booleanValue()) {
            EGL.create();
        }
    }
}

