/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import org.lwjgl.system.APIUtil;

public final class Version {
    public static final int VERSION_MAJOR = 3;
    public static final int VERSION_MINOR = 0;
    public static final int VERSION_REVISION = 0;
    public static final BuildType BUILD_TYPE = BuildType.STABLE;

    private Version() {
    }

    public static void main(String[] args) {
        System.out.println(Version.getVersion());
    }

    public static String getVersion() {
        return String.valueOf(3) + '.' + 0 + '.' + 0 + Version.BUILD_TYPE.postfix + ' ' + Version.getVersionImpl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersionImpl() {
        URL url = Thread.currentThread().getContextClassLoader().getResource("org/lwjgl/Version.class");
        if (url == null) return "SNAPSHOT";
        String classURL = url.toString();
        if (!classURL.startsWith("jar:")) return "SNAPSHOT";
        try (InputStream stream = new URL(classURL.substring(0, classURL.lastIndexOf("!") + 1) + '/' + "META-INF/MANIFEST.MF").openStream();){
            String string = new Manifest(stream).getAttributes("org/lwjgl/").getValue("Implementation-Version");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace(APIUtil.DEBUG_STREAM);
        }
        return "SNAPSHOT";
    }

    public static enum BuildType {
        ALPHA("a"),
        BETA("b"),
        STABLE("");

        final String postfix;

        private BuildType(String postfix) {
            this.postfix = postfix;
        }
    }
}

