/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAllocationFunction;
import org.lwjgl.vulkan.VkAllocationFunctionI;
import org.lwjgl.vulkan.VkFreeFunction;
import org.lwjgl.vulkan.VkFreeFunctionI;
import org.lwjgl.vulkan.VkInternalAllocationNotification;
import org.lwjgl.vulkan.VkInternalAllocationNotificationI;
import org.lwjgl.vulkan.VkInternalFreeNotification;
import org.lwjgl.vulkan.VkInternalFreeNotificationI;
import org.lwjgl.vulkan.VkReallocationFunction;
import org.lwjgl.vulkan.VkReallocationFunctionI;

public class VkAllocationCallbacks
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PUSERDATA;
    public static final int PFNALLOCATION;
    public static final int PFNREALLOCATION;
    public static final int PFNFREE;
    public static final int PFNINTERNALALLOCATION;
    public static final int PFNINTERNALFREE;

    VkAllocationCallbacks(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkAllocationCallbacks(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkAllocationCallbacks.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long pUserData() {
        return VkAllocationCallbacks.npUserData(this.address());
    }

    public VkAllocationFunction pfnAllocation() {
        return VkAllocationFunction.create(VkAllocationCallbacks.npfnAllocation(this.address()));
    }

    public VkReallocationFunction pfnReallocation() {
        return VkReallocationFunction.create(VkAllocationCallbacks.npfnReallocation(this.address()));
    }

    public VkFreeFunction pfnFree() {
        return VkFreeFunction.create(VkAllocationCallbacks.npfnFree(this.address()));
    }

    public VkInternalAllocationNotification pfnInternalAllocation() {
        return VkInternalAllocationNotification.create(VkAllocationCallbacks.npfnInternalAllocation(this.address()));
    }

    public VkInternalFreeNotification pfnInternalFree() {
        return VkInternalFreeNotification.create(VkAllocationCallbacks.npfnInternalFree(this.address()));
    }

    public VkAllocationCallbacks pUserData(long value) {
        VkAllocationCallbacks.npUserData(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnAllocation(VkAllocationFunctionI value) {
        VkAllocationCallbacks.npfnAllocation(this.address(), VkAllocationCallbacks.addressSafe(value));
        return this;
    }

    public VkAllocationCallbacks pfnReallocation(VkReallocationFunctionI value) {
        VkAllocationCallbacks.npfnReallocation(this.address(), VkAllocationCallbacks.addressSafe(value));
        return this;
    }

    public VkAllocationCallbacks pfnFree(VkFreeFunctionI value) {
        VkAllocationCallbacks.npfnFree(this.address(), VkAllocationCallbacks.addressSafe(value));
        return this;
    }

    public VkAllocationCallbacks pfnInternalAllocation(VkInternalAllocationNotificationI value) {
        VkAllocationCallbacks.npfnInternalAllocation(this.address(), VkAllocationCallbacks.addressSafe(value));
        return this;
    }

    public VkAllocationCallbacks pfnInternalFree(VkInternalFreeNotificationI value) {
        VkAllocationCallbacks.npfnInternalFree(this.address(), VkAllocationCallbacks.addressSafe(value));
        return this;
    }

    public VkAllocationCallbacks set(long pUserData, VkAllocationFunctionI pfnAllocation, VkReallocationFunctionI pfnReallocation, VkFreeFunctionI pfnFree, VkInternalAllocationNotificationI pfnInternalAllocation, VkInternalFreeNotificationI pfnInternalFree) {
        this.pUserData(pUserData);
        this.pfnAllocation(pfnAllocation);
        this.pfnReallocation(pfnReallocation);
        this.pfnFree(pfnFree);
        this.pfnInternalAllocation(pfnInternalAllocation);
        this.pfnInternalFree(pfnInternalFree);
        return this;
    }

    public VkAllocationCallbacks nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkAllocationCallbacks set(VkAllocationCallbacks src) {
        return this.nset(src.address());
    }

    public static VkAllocationCallbacks malloc() {
        return VkAllocationCallbacks.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkAllocationCallbacks calloc() {
        return VkAllocationCallbacks.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkAllocationCallbacks create() {
        return new VkAllocationCallbacks(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkAllocationCallbacks create(long address) {
        return address == 0L ? null : new VkAllocationCallbacks(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkAllocationCallbacks.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAllocationCallbacks.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkAllocationCallbacks mallocStack() {
        return VkAllocationCallbacks.mallocStack(MemoryStack.stackGet());
    }

    public static VkAllocationCallbacks callocStack() {
        return VkAllocationCallbacks.callocStack(MemoryStack.stackGet());
    }

    public static VkAllocationCallbacks mallocStack(MemoryStack stack) {
        return VkAllocationCallbacks.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAllocationCallbacks callocStack(MemoryStack stack) {
        return VkAllocationCallbacks.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAllocationCallbacks.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAllocationCallbacks.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAllocationCallbacks.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAllocationCallbacks.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PUSERDATA);
    }

    public static long npfnAllocation(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PFNALLOCATION);
    }

    public static long npfnReallocation(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PFNREALLOCATION);
    }

    public static long npfnFree(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PFNFREE);
    }

    public static long npfnInternalAllocation(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PFNINTERNALALLOCATION);
    }

    public static long npfnInternalFree(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PFNINTERNALFREE);
    }

    public static void npUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PUSERDATA, value);
    }

    public static void npfnAllocation(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PFNALLOCATION, Checks.checkPointer(value));
    }

    public static void npfnReallocation(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PFNREALLOCATION, Checks.checkPointer(value));
    }

    public static void npfnFree(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PFNFREE, Checks.checkPointer(value));
    }

    public static void npfnInternalAllocation(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PFNINTERNALALLOCATION, value);
    }

    public static void npfnInternalFree(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PFNINTERNALFREE, value);
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PFNALLOCATION));
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PFNREALLOCATION));
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PFNFREE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkAllocationCallbacks.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkAllocationCallbacks.__struct(VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PUSERDATA = layout.offsetof(0);
        PFNALLOCATION = layout.offsetof(1);
        PFNREALLOCATION = layout.offsetof(2);
        PFNFREE = layout.offsetof(3);
        PFNINTERNALALLOCATION = layout.offsetof(4);
        PFNINTERNALFREE = layout.offsetof(5);
    }

    public static final class Buffer
    extends StructBuffer<VkAllocationCallbacks, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkAllocationCallbacks newInstance(long address) {
            return new VkAllocationCallbacks(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long pUserData() {
            return VkAllocationCallbacks.npUserData(this.address());
        }

        public VkAllocationFunction pfnAllocation() {
            return VkAllocationFunction.create(VkAllocationCallbacks.npfnAllocation(this.address()));
        }

        public VkReallocationFunction pfnReallocation() {
            return VkReallocationFunction.create(VkAllocationCallbacks.npfnReallocation(this.address()));
        }

        public VkFreeFunction pfnFree() {
            return VkFreeFunction.create(VkAllocationCallbacks.npfnFree(this.address()));
        }

        public VkInternalAllocationNotification pfnInternalAllocation() {
            return VkInternalAllocationNotification.create(VkAllocationCallbacks.npfnInternalAllocation(this.address()));
        }

        public VkInternalFreeNotification pfnInternalFree() {
            return VkInternalFreeNotification.create(VkAllocationCallbacks.npfnInternalFree(this.address()));
        }

        public Buffer pUserData(long value) {
            VkAllocationCallbacks.npUserData(this.address(), value);
            return this;
        }

        public Buffer pfnAllocation(VkAllocationFunctionI value) {
            VkAllocationCallbacks.npfnAllocation(this.address(), VkAllocationCallbacks.addressSafe(value));
            return this;
        }

        public Buffer pfnReallocation(VkReallocationFunctionI value) {
            VkAllocationCallbacks.npfnReallocation(this.address(), VkAllocationCallbacks.addressSafe(value));
            return this;
        }

        public Buffer pfnFree(VkFreeFunctionI value) {
            VkAllocationCallbacks.npfnFree(this.address(), VkAllocationCallbacks.addressSafe(value));
            return this;
        }

        public Buffer pfnInternalAllocation(VkInternalAllocationNotificationI value) {
            VkAllocationCallbacks.npfnInternalAllocation(this.address(), VkAllocationCallbacks.addressSafe(value));
            return this;
        }

        public Buffer pfnInternalFree(VkInternalFreeNotificationI value) {
            VkAllocationCallbacks.npfnInternalFree(this.address(), VkAllocationCallbacks.addressSafe(value));
            return this;
        }
    }
}

