/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.windows.RECT;

public class MONITORINFOEX
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CBSIZE;
    public static final int RCMONITOR;
    public static final int RCWORK;
    public static final int DWFLAGS;
    public static final int SZDEVICE;

    MONITORINFOEX(long address, ByteBuffer container) {
        super(address, container);
    }

    public MONITORINFOEX(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), MONITORINFOEX.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int cbSize() {
        return MONITORINFOEX.ncbSize(this.address());
    }

    public RECT rcMonitor() {
        return MONITORINFOEX.nrcMonitor(this.address());
    }

    public RECT rcWork() {
        return MONITORINFOEX.nrcWork(this.address());
    }

    public int dwFlags() {
        return MONITORINFOEX.ndwFlags(this.address());
    }

    public ByteBuffer szDevice() {
        return MONITORINFOEX.nszDevice(this.address());
    }

    public String szDeviceString() {
        return MONITORINFOEX.nszDeviceString(this.address());
    }

    public MONITORINFOEX cbSize(int value) {
        MONITORINFOEX.ncbSize(this.address(), value);
        return this;
    }

    public MONITORINFOEX nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public MONITORINFOEX set(MONITORINFOEX src) {
        return this.nset(src.address());
    }

    public static MONITORINFOEX malloc() {
        return MONITORINFOEX.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static MONITORINFOEX calloc() {
        return MONITORINFOEX.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static MONITORINFOEX create() {
        return new MONITORINFOEX(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static MONITORINFOEX create(long address) {
        return address == 0L ? null : new MONITORINFOEX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return MONITORINFOEX.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MONITORINFOEX.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static MONITORINFOEX mallocStack() {
        return MONITORINFOEX.mallocStack(MemoryStack.stackGet());
    }

    public static MONITORINFOEX callocStack() {
        return MONITORINFOEX.callocStack(MemoryStack.stackGet());
    }

    public static MONITORINFOEX mallocStack(MemoryStack stack) {
        return MONITORINFOEX.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MONITORINFOEX callocStack(MemoryStack stack) {
        return MONITORINFOEX.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MONITORINFOEX.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MONITORINFOEX.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return MONITORINFOEX.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return MONITORINFOEX.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncbSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CBSIZE);
    }

    public static RECT nrcMonitor(long struct) {
        return RECT.create(struct + (long)RCMONITOR);
    }

    public static RECT nrcWork(long struct) {
        return RECT.create(struct + (long)RCWORK);
    }

    public static int ndwFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DWFLAGS);
    }

    public static ByteBuffer nszDevice(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)SZDEVICE, 64);
    }

    public static String nszDeviceString(long struct) {
        return MemoryUtil.memUTF16(struct + (long)SZDEVICE);
    }

    public static void ncbSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CBSIZE, value);
    }

    static {
        Struct.Layout layout = MONITORINFOEX.__struct(MONITORINFOEX.__member(4), MONITORINFOEX.__member(RECT.SIZEOF, RECT.ALIGNOF), MONITORINFOEX.__member(RECT.SIZEOF, RECT.ALIGNOF), MONITORINFOEX.__member(4), MONITORINFOEX.__array(2, 32));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CBSIZE = layout.offsetof(0);
        RCMONITOR = layout.offsetof(1);
        RCWORK = layout.offsetof(2);
        DWFLAGS = layout.offsetof(3);
        SZDEVICE = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<MONITORINFOEX, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected MONITORINFOEX newInstance(long address) {
            return new MONITORINFOEX(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int cbSize() {
            return MONITORINFOEX.ncbSize(this.address());
        }

        public RECT rcMonitor() {
            return MONITORINFOEX.nrcMonitor(this.address());
        }

        public RECT rcWork() {
            return MONITORINFOEX.nrcWork(this.address());
        }

        public int dwFlags() {
            return MONITORINFOEX.ndwFlags(this.address());
        }

        public ByteBuffer szDevice() {
            return MONITORINFOEX.nszDevice(this.address());
        }

        public String szDeviceString() {
            return MONITORINFOEX.nszDeviceString(this.address());
        }

        public Buffer cbSize(int value) {
            MONITORINFOEX.ncbSize(this.address(), value);
            return this;
        }
    }
}

