/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Method;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.CallbackI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.dyncall.DynCallback;

public abstract class Callback
extends Pointer.Default
implements NativeResource {
    private static final long VOID;
    private static final long BOOLEAN;
    private static final long BYTE;
    private static final long SHORT;
    private static final long INT;
    private static final long LONG;
    private static final long FLOAT;
    private static final long DOUBLE;
    private static final long PTR;

    protected Callback(long address) {
        super(address);
    }

    @Override
    public void free() {
        Callback.free(this.address());
    }

    private static native long getNativeCallbacks(Method[] var0, long var1);

    static long getNativeFunction(char type) {
        switch (type) {
            case 'v': {
                return VOID;
            }
            case 'B': {
                return BOOLEAN;
            }
            case 'c': {
                return BYTE;
            }
            case 's': {
                return SHORT;
            }
            case 'i': {
                return INT;
            }
            case 'l': {
                return LONG;
            }
            case 'p': {
                return PTR;
            }
            case 'f': {
                return FLOAT;
            }
            case 'd': {
                return DOUBLE;
            }
        }
        throw new IllegalArgumentException();
    }

    public static <T extends CallbackI> T get(long functionPointer) {
        if (functionPointer == 0L) {
            return null;
        }
        return (T)((CallbackI)MemoryUtil.memGlobalRefToObject(DynCallback.dcbGetUserData(functionPointer)));
    }

    public static void free(long functionPointer) {
        MemoryUtil.memDeleteGlobalRef(DynCallback.dcbGetUserData(functionPointer));
        DynCallback.dcbFreeCallback(functionPointer);
    }

    static {
        try (MemoryStack stack = MemoryStack.stackPush();){
            Class[] params = new Class[]{Long.TYPE};
            Method[] methods = new Method[]{CallbackI.V.class.getDeclaredMethod("callback", params), CallbackI.Z.class.getDeclaredMethod("callback", params), CallbackI.B.class.getDeclaredMethod("callback", params), CallbackI.S.class.getDeclaredMethod("callback", params), CallbackI.I.class.getDeclaredMethod("callback", params), CallbackI.J.class.getDeclaredMethod("callback", params), CallbackI.F.class.getDeclaredMethod("callback", params), CallbackI.D.class.getDeclaredMethod("callback", params), CallbackI.P.class.getDeclaredMethod("callback", params)};
            PointerBuffer callbacks = stack.mallocPointer(methods.length);
            Callback.getNativeCallbacks(methods, MemoryUtil.memAddress(callbacks));
            VOID = callbacks.get();
            BOOLEAN = callbacks.get();
            BYTE = callbacks.get();
            SHORT = callbacks.get();
            INT = callbacks.get();
            LONG = callbacks.get();
            FLOAT = callbacks.get();
            DOUBLE = callbacks.get();
            PTR = callbacks.get();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize native callbacks.", e);
        }
    }
}

