/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class STBRPContext
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    STBRPContext(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBRPContext(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), STBRPContext.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public static STBRPContext malloc() {
        return STBRPContext.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBRPContext calloc() {
        return STBRPContext.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBRPContext create() {
        return new STBRPContext(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static STBRPContext create(long address) {
        return address == 0L ? null : new STBRPContext(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBRPContext.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBRPContext.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBRPContext mallocStack() {
        return STBRPContext.mallocStack(MemoryStack.stackGet());
    }

    public static STBRPContext callocStack() {
        return STBRPContext.callocStack(MemoryStack.stackGet());
    }

    public static STBRPContext mallocStack(MemoryStack stack) {
        return STBRPContext.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBRPContext callocStack(MemoryStack stack) {
        return STBRPContext.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBRPContext.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBRPContext.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBRPContext.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBRPContext.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    static {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = STBRPContext.offsets(MemoryUtil.memAddress(offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static final class Buffer
    extends StructBuffer<STBRPContext, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected STBRPContext newInstance(long address) {
            return new STBRPContext(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }
    }
}

