/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class OESVertexArrayObject {
    public static final int GL_VERTEX_ARRAY_BINDING_OES = 34229;

    protected OESVertexArrayObject() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glBindVertexArrayOES, caps.glDeleteVertexArraysOES, caps.glGenVertexArraysOES, caps.glIsVertexArrayOES);
    }

    public static void glBindVertexArrayOES(int array) {
        long __functionAddress = GLES.getCapabilities().glBindVertexArrayOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, array);
    }

    public static void nglDeleteVertexArraysOES(int n, long arrays) {
        long __functionAddress = GLES.getCapabilities().glDeleteVertexArraysOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, n, arrays);
    }

    public static void glDeleteVertexArraysOES(IntBuffer arrays) {
        OESVertexArrayObject.nglDeleteVertexArraysOES(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteVertexArraysOES(int array) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.ints(array);
            OESVertexArrayObject.nglDeleteVertexArraysOES(1, MemoryUtil.memAddress(arrays));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenVertexArraysOES(int n, long arrays) {
        long __functionAddress = GLES.getCapabilities().glGenVertexArraysOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, n, arrays);
    }

    public static void glGenVertexArraysOES(IntBuffer arrays) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)arrays, 1);
        }
        OESVertexArrayObject.nglGenVertexArraysOES(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenVertexArraysOES() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer arrays = stack.callocInt(1);
            OESVertexArrayObject.nglGenVertexArraysOES(1, MemoryUtil.memAddress(arrays));
            int n = arrays.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsVertexArrayOES(int array) {
        long __functionAddress = GLES.getCapabilities().glIsVertexArrayOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, array);
    }

    public static void glDeleteVertexArraysOES(int[] arrays) {
        long __functionAddress = GLES.getCapabilities().glDeleteVertexArraysOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, arrays.length, arrays);
    }

    public static void glGenVertexArraysOES(int[] arrays) {
        long __functionAddress = GLES.getCapabilities().glGenVertexArraysOES;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(arrays, 1);
        }
        JNI.callPV(__functionAddress, arrays.length, arrays);
    }
}

