/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVDrawInstanced {
    protected NVDrawInstanced() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glDrawArraysInstancedNV, caps.glDrawElementsInstancedNV);
    }

    public static void glDrawArraysInstancedNV(int mode, int first, int count, int primcount) {
        long __functionAddress = GLES.getCapabilities().glDrawArraysInstancedNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, mode, first, count, primcount);
    }

    public static void nglDrawElementsInstancedNV(int mode, int count, int type, long indices, int primcount) {
        long __functionAddress = GLES.getCapabilities().glDrawElementsInstancedNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstancedNV(int mode, int count, int type, long indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        NVDrawInstanced.nglDrawElementsInstancedNV(mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstancedNV(int mode, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        NVDrawInstanced.nglDrawElementsInstancedNV(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedNV(int mode, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        NVDrawInstanced.nglDrawElementsInstancedNV(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedNV(int mode, ShortBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        NVDrawInstanced.nglDrawElementsInstancedNV(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedNV(int mode, IntBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        NVDrawInstanced.nglDrawElementsInstancedNV(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount);
    }
}

