/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTDisjointTimerQuery {
    public static final int GL_QUERY_COUNTER_BITS_EXT = 34916;
    public static final int GL_CURRENT_QUERY_EXT = 34917;
    public static final int GL_QUERY_RESULT_EXT = 34918;
    public static final int GL_QUERY_RESULT_AVAILABLE_EXT = 34919;
    public static final int GL_TIME_ELAPSED_EXT = 35007;
    public static final int GL_TIMESTAMP_EXT = 36392;
    public static final int GL_GPU_DISJOINT_EXT = 36795;

    protected EXTDisjointTimerQuery() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glGenQueriesEXT, caps.glDeleteQueriesEXT, caps.glIsQueryEXT, caps.glBeginQueryEXT, caps.glEndQueryEXT, caps.glQueryCounterEXT, caps.glGetQueryivEXT, caps.glGetQueryObjectuivEXT, caps.glGetQueryObjecti64vEXT, caps.glGetQueryObjectui64vEXT);
    }

    public static void nglGenQueriesEXT(int n, long ids) {
        long __functionAddress = GLES.getCapabilities().glGenQueriesEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, n, ids);
    }

    public static void glGenQueriesEXT(IntBuffer ids) {
        EXTDisjointTimerQuery.nglGenQueriesEXT(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenQueriesEXT() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.callocInt(1);
            EXTDisjointTimerQuery.nglGenQueriesEXT(1, MemoryUtil.memAddress(ids));
            int n = ids.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDeleteQueriesEXT(int n, long ids) {
        long __functionAddress = GLES.getCapabilities().glDeleteQueriesEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, n, ids);
    }

    public static void glDeleteQueriesEXT(IntBuffer ids) {
        EXTDisjointTimerQuery.nglDeleteQueriesEXT(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteQueriesEXT(int id) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer ids = stack.ints(id);
            EXTDisjointTimerQuery.nglDeleteQueriesEXT(1, MemoryUtil.memAddress(ids));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsQueryEXT(int id) {
        long __functionAddress = GLES.getCapabilities().glIsQueryEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, id);
    }

    public static void glBeginQueryEXT(int target, int id) {
        long __functionAddress = GLES.getCapabilities().glBeginQueryEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target, id);
    }

    public static void glEndQueryEXT(int target) {
        long __functionAddress = GLES.getCapabilities().glEndQueryEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, target);
    }

    public static void glQueryCounterEXT(int id, int target) {
        long __functionAddress = GLES.getCapabilities().glQueryCounterEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, id, target);
    }

    public static void nglGetQueryivEXT(int target, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetQueryivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetQueryivEXT(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDisjointTimerQuery.nglGetQueryivEXT(target, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetQueryiEXT(int target, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDisjointTimerQuery.nglGetQueryivEXT(target, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetQueryObjectivEXT(int id, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetQueryObjectivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectivEXT(int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDisjointTimerQuery.nglGetQueryObjectivEXT(id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetQueryObjectiEXT(int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDisjointTimerQuery.nglGetQueryObjectivEXT(id, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetQueryObjectuivEXT(int id, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetQueryObjectuivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectuivEXT(int id, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDisjointTimerQuery.nglGetQueryObjectuivEXT(id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetQueryObjectuiEXT(int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTDisjointTimerQuery.nglGetQueryObjectuivEXT(id, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetQueryObjecti64vEXT(int id, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetQueryObjecti64vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjecti64vEXT(int id, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDisjointTimerQuery.nglGetQueryObjecti64vEXT(id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetQueryObjecti64EXT(int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            EXTDisjointTimerQuery.nglGetQueryObjecti64vEXT(id, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetQueryObjectui64vEXT(int id, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetQueryObjectui64vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectui64vEXT(int id, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTDisjointTimerQuery.nglGetQueryObjectui64vEXT(id, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long glGetQueryObjectui64EXT(int id, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            EXTDisjointTimerQuery.nglGetQueryObjectui64vEXT(id, pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGenQueriesEXT(int[] ids) {
        long __functionAddress = GLES.getCapabilities().glGenQueriesEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, ids.length, ids);
    }

    public static void glDeleteQueriesEXT(int[] ids) {
        long __functionAddress = GLES.getCapabilities().glDeleteQueriesEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, ids.length, ids);
    }

    public static void glGetQueryivEXT(int target, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetQueryivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, target, pname, params);
    }

    public static void glGetQueryObjectivEXT(int id, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetQueryObjectivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectuivEXT(int id, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetQueryObjectuivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjecti64vEXT(int id, int pname, long[] params) {
        long __functionAddress = GLES.getCapabilities().glGetQueryObjecti64vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }

    public static void glGetQueryObjectui64vEXT(int id, int pname, long[] params) {
        long __functionAddress = GLES.getCapabilities().glGetQueryObjectui64vEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, id, pname, params);
    }
}

