/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLXCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class GLXNVSwapGroup {
    protected GLXNVSwapGroup() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLXCapabilities caps) {
        return Checks.checkFunctions(caps.glXJoinSwapGroupNV, caps.glXBindSwapBarrierNV, caps.glXQuerySwapGroupNV, caps.glXQueryMaxSwapGroupsNV, caps.glXQueryFrameCountNV, caps.glXResetFrameCountNV);
    }

    public static int glXJoinSwapGroupNV(long display, long drawable, int group) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXJoinSwapGroupNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(drawable);
        }
        return JNI.callPPI(__functionAddress, display, drawable, group);
    }

    public static int glXBindSwapBarrierNV(long display, int group, int barrier) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXBindSwapBarrierNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return JNI.callPI(__functionAddress, display, group, barrier);
    }

    public static int nglXQuerySwapGroupNV(long display, long drawable, long group, long barrier) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQuerySwapGroupNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(drawable);
        }
        return JNI.callPPPPI(__functionAddress, display, drawable, group, barrier);
    }

    public static int glXQuerySwapGroupNV(long display, long drawable, IntBuffer group, IntBuffer barrier) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)group, 1);
            Checks.checkBuffer((Buffer)barrier, 1);
        }
        return GLXNVSwapGroup.nglXQuerySwapGroupNV(display, drawable, MemoryUtil.memAddress(group), MemoryUtil.memAddress(barrier));
    }

    public static int nglXQueryMaxSwapGroupsNV(long display, int screen, long maxGroups, long maxBarriers) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryMaxSwapGroupsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return JNI.callPPPI(__functionAddress, display, screen, maxGroups, maxBarriers);
    }

    public static int glXQueryMaxSwapGroupsNV(long display, int screen, IntBuffer maxGroups, IntBuffer maxBarriers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)maxGroups, 1);
            Checks.checkBuffer((Buffer)maxBarriers, 1);
        }
        return GLXNVSwapGroup.nglXQueryMaxSwapGroupsNV(display, screen, MemoryUtil.memAddress(maxGroups), MemoryUtil.memAddress(maxBarriers));
    }

    public static int nglXQueryFrameCountNV(long display, int screen, long count) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryFrameCountNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return JNI.callPPI(__functionAddress, display, screen, count);
    }

    public static int glXQueryFrameCountNV(long display, int screen, IntBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        return GLXNVSwapGroup.nglXQueryFrameCountNV(display, screen, MemoryUtil.memAddress(count));
    }

    public static int glXResetFrameCountNV(long display, int screen) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXResetFrameCountNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return JNI.callPI(__functionAddress, display, screen);
    }

    public static int glXQuerySwapGroupNV(long display, long drawable, int[] group, int[] barrier) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQuerySwapGroupNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(drawable);
            Checks.checkBuffer(group, 1);
            Checks.checkBuffer(barrier, 1);
        }
        return JNI.callPPPPI(__functionAddress, display, drawable, group, barrier);
    }

    public static int glXQueryMaxSwapGroupsNV(long display, int screen, int[] maxGroups, int[] maxBarriers) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryMaxSwapGroupsNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkBuffer(maxGroups, 1);
            Checks.checkBuffer(maxBarriers, 1);
        }
        return JNI.callPPPI(__functionAddress, display, screen, maxGroups, maxBarriers);
    }

    public static int glXQueryFrameCountNV(long display, int screen, int[] count) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXQueryFrameCountNV;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkBuffer(count, 1);
        }
        return JNI.callPPI(__functionAddress, display, screen, count);
    }
}

