/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBGetProgramBinary {
    public static final int GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 33367;
    public static final int GL_PROGRAM_BINARY_LENGTH = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS = 34815;

    protected ARBGetProgramBinary() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glGetProgramBinary, caps.glProgramBinary, caps.glProgramParameteri);
    }

    public static void nglGetProgramBinary(int program, int bufSize, long length, long binaryFormat, long binary) {
        long __functionAddress = GL.getCapabilities().glGetProgramBinary;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPPV(__functionAddress, program, bufSize, length, binaryFormat, binary);
    }

    public static void glGetProgramBinary(int program, IntBuffer length, IntBuffer binaryFormat, ByteBuffer binary) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        ARBGetProgramBinary.nglGetProgramBinary(program, binary.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static void nglProgramBinary(int program, int binaryFormat, long binary, int length) {
        long __functionAddress = GL.getCapabilities().glProgramBinary;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, binaryFormat, binary, length);
    }

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary) {
        ARBGetProgramBinary.nglProgramBinary(program, binaryFormat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void glProgramParameteri(int program, int pname, int value) {
        long __functionAddress = GL.getCapabilities().glProgramParameteri;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, pname, value);
    }

    public static void glGetProgramBinary(int program, int[] length, int[] binaryFormat, ByteBuffer binary) {
        long __functionAddress = GL.getCapabilities().glGetProgramBinary;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
            Checks.checkBuffer(binaryFormat, 1);
        }
        JNI.callPPPV(__functionAddress, program, binary.remaining(), length, binaryFormat, MemoryUtil.memAddress(binary));
    }
}

