/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nanovg;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class NVGGlyphPosition
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STR;
    public static final int X;
    public static final int MINX;
    public static final int MAXX;

    NVGGlyphPosition(long address, ByteBuffer container) {
        super(address, container);
    }

    public NVGGlyphPosition(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), NVGGlyphPosition.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long str() {
        return NVGGlyphPosition.nstr(this.address());
    }

    public float x() {
        return NVGGlyphPosition.nx(this.address());
    }

    public float minx() {
        return NVGGlyphPosition.nminx(this.address());
    }

    public float maxx() {
        return NVGGlyphPosition.nmaxx(this.address());
    }

    public NVGGlyphPosition str(long value) {
        NVGGlyphPosition.nstr(this.address(), value);
        return this;
    }

    public NVGGlyphPosition x(float value) {
        NVGGlyphPosition.nx(this.address(), value);
        return this;
    }

    public NVGGlyphPosition minx(float value) {
        NVGGlyphPosition.nminx(this.address(), value);
        return this;
    }

    public NVGGlyphPosition maxx(float value) {
        NVGGlyphPosition.nmaxx(this.address(), value);
        return this;
    }

    public NVGGlyphPosition set(long str, float x, float minx, float maxx) {
        this.str(str);
        this.x(x);
        this.minx(minx);
        this.maxx(maxx);
        return this;
    }

    public NVGGlyphPosition nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public NVGGlyphPosition set(NVGGlyphPosition src) {
        return this.nset(src.address());
    }

    public static NVGGlyphPosition malloc() {
        return NVGGlyphPosition.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static NVGGlyphPosition calloc() {
        return NVGGlyphPosition.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static NVGGlyphPosition create() {
        return new NVGGlyphPosition(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static NVGGlyphPosition create(long address) {
        return address == 0L ? null : new NVGGlyphPosition(address, null);
    }

    public static Buffer malloc(int capacity) {
        return NVGGlyphPosition.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NVGGlyphPosition.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static NVGGlyphPosition mallocStack() {
        return NVGGlyphPosition.mallocStack(MemoryStack.stackGet());
    }

    public static NVGGlyphPosition callocStack() {
        return NVGGlyphPosition.callocStack(MemoryStack.stackGet());
    }

    public static NVGGlyphPosition mallocStack(MemoryStack stack) {
        return NVGGlyphPosition.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NVGGlyphPosition callocStack(MemoryStack stack) {
        return NVGGlyphPosition.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NVGGlyphPosition.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NVGGlyphPosition.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NVGGlyphPosition.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NVGGlyphPosition.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nstr(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)STR);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float nminx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MINX);
    }

    public static float nmaxx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)MAXX);
    }

    public static void nstr(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)STR, Checks.checkPointer(value));
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void nminx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MINX, value);
    }

    public static void nmaxx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)MAXX, value);
    }

    public static void validate(long struct) {
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)STR));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            NVGGlyphPosition.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = NVGGlyphPosition.__struct(NVGGlyphPosition.__member(POINTER_SIZE), NVGGlyphPosition.__member(4), NVGGlyphPosition.__member(4), NVGGlyphPosition.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STR = layout.offsetof(0);
        X = layout.offsetof(1);
        MINX = layout.offsetof(2);
        MAXX = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<NVGGlyphPosition, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected NVGGlyphPosition newInstance(long address) {
            return new NVGGlyphPosition(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long str() {
            return NVGGlyphPosition.nstr(this.address());
        }

        public float x() {
            return NVGGlyphPosition.nx(this.address());
        }

        public float minx() {
            return NVGGlyphPosition.nminx(this.address());
        }

        public float maxx() {
            return NVGGlyphPosition.nmaxx(this.address());
        }

        public Buffer str(long value) {
            NVGGlyphPosition.nstr(this.address(), value);
            return this;
        }

        public Buffer x(float value) {
            NVGGlyphPosition.nx(this.address(), value);
            return this;
        }

        public Buffer minx(float value) {
            NVGGlyphPosition.nminx(this.address(), value);
            return this;
        }

        public Buffer maxx(float value) {
            NVGGlyphPosition.nmaxx(this.address(), value);
            return this;
        }
    }
}

