### Name: image.plot
### Title: Draws image plot with a legend strip for the color scale.
### Aliases: image.plot
### Keywords: hplot

### ** Examples


x<- 1:10 
y<- 1:15 
z<- outer( x,y,"+") 
image.plot(x,y,z) 

# or obj<- list( x=x,y=y,z=z); image.plot(obj)

# now add some points on diagonal with some clipping anticipated 
   points( 5:12, 5:12, pch="X", cex=3)

#
#fat (5% of figure) and short (50% of figure)  legend strip on the bottom 
  image.plot( x,y,z,legend.width=.05, legend.shrink=.5, horizontal=TRUE) 


set.panel()

#
# Here is a strategy to add a common legend to a panel of plots
# consult the  split.screen help file for more explanations
# draw two images top and bottom and add a single legned strip on the right side
# first divide screen into the figure region and strip on the right ot put a 
# legend. 

   split.screen( rbind(c(0, .8,0,1), c(.8,1,0,1)))

# now divide up the figure region 
   split.screen(c(2,1), screen=1)-> ind

zr<- range( 2,35)
# first image
   screen( ind[1])
   image( x,y,z, col=tim.colors(), zlim=zr)

# second image
   screen( ind[2])
   image( x,y,z+10, col=tim.colors(), zlim =zr)

# move to skinny region on right and draw the legend strip 
   screen( 2)
   image.plot( zlim=zr,legend.only=TRUE, smallplot=c(.1,.2, .3,.7),
   col=tim.colors())

   close.screen( all=TRUE)

# you can always add a legend arbitrarily to any plot;
# note that here the plot is too big for the vertical strip but the
# horizontal fits nicely.
plot( 1:10, 1:10)
image.plot( zlim=c(0,25), legend.only=TRUE)
image.plot( zlim=c(0,25), legend.only=TRUE, horizontal =TRUE)

# combining the  usual image function and adding a legend
# first change margin for some more room
## Not run: 
##D par( mar=c(10,5,5,5))
##D image( x,y,z, col=topo.colors(64))
##D image.plot( zlim=c(0,25), nlevel=64,legend.only=TRUE, horizontal=TRUE)
## End(Not run)
#
# 
# sorting difference in formatting between matrix storage and the image 
#plot depiction
A<- matrix( 1:48, ncol=6)
# Note that matrix(c(A), ncol=6) == A
image.plot(1:8, 1:6, A)
# add labels to each box 
text( c( row(A)), c( col(A)), A)
# and the indices ...
text( c( row(A)), c( col(A))-.25,  
   paste( "(", c(row(A)), ",",c(col(A)),")", sep=""), col="grey")

# "columns" of A are horizontal and rows are ordered from bottom to top!
#
# matrix in its usual tabluar form where the rows are y  and columns are x
image.plot( t( A[6:1,]), axes=FALSE)


 



