### Name: survkit
### Title: Weibull and Cox Models with Random Effects
### Aliases: survkit
### Keywords: models

### ** Examples

# y <- trunc(rweibull(20,2,20))
y <- c(6,22,43,16,7,6,15,35,10,9,18,34,7,13,10,17,14,19,11,13)
# cens <- rbinom(20,1,0.9)
cens <- c(1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1)
id <- gl(2,10)
# x <- rnorm(20)
x <- c(1.82881379,1.06606868,0.70877744,-0.09932880,-0.60626148,-0.75371046,
  0.23884069,0.51199483,-0.73060095,-0.93222151,2.27947539,-0.73855454,
 -0.36412735,-0.89122114,-0.05025962,-0.10001587,1.11460865,-1.87315971,
 -0.11280052,-1.6880509)
# Kaplan-Meier estimates
survkit(y, censor=cens, model="Kaplan")
# null Weibull model
survkit(y, censor=cens)
# one time-constant covariate
survkit(y, censor=cens, ccov=~x)
# stratify
survkit(y, censor=cens, ccov=~x, strata=id)
# estimate a normal random effect
survkit(y, censor=cens, ccov=~x, random=id, dist="normal",
        estimate=c(0.1,10,0.01), moments=TRUE)
# try a fixed value for the normal random effect
survkit(y, censor=cens, ccov=~x, random=id, dist="normal",
        estimate=1.3)
# estimate a log-gamma random effect
survkit(y, censor=cens, ccov=~x, random=id, dist="loggamma",
        estimate=c(0.1,10,0.01))
# estimate a log-gamma random effect by integrating it out
survkit(y, censor=cens, ccov=~x, dist="loggamma", estimate=1.4,
        integ=id, jointmode=TRUE)
# try a fixed value of the log-gamma random effect, integrating it out
survkit(y, censor=cens, ccov=~x, dist="loggamma", estimate=1,
        integ=id)
#
# Cox model with one time-constant covariate
print(z <- survkit(y, censor=cens, ccov=~x, model="Cox", residuals=TRUE,
        baseline=TRUE))
residuals(z)
baseline(z)
# obtain the quantiles
print(z <- survkit(y, censor=cens, ccov=~x, model="Cox",
        survival="quantiles", svalues=seq(10,90,by=10)))
survival(z)
# estimate a log-gamma random effect
survkit(y, censor=cens, ccov=~x, model="Cox", random=id,
        dist="loggamma", estimate=c(0.1,10,0.01))



