### Name: cmcre
### Title: Continuous-time Two-state Markov Processes with Random Effect
### Aliases: cmcre
### Keywords: models

### ** Examples

# 12 subjects observed at intervals of 7 days
y <- matrix(c(1,7,1,2,3,5,
        2,7,10,2,2,0,
        3,7,7,0,1,1,
        4,7,2,1,0,7,
        5,7,1,1,1,11,
        6,7,5,4,4,1,
        7,7,1,1,1,8,
        8,7,2,3,4,2,
        9,7,9,0,0,0,
        10,7,0,1,2,8,
        11,7,8,2,2,1,
        12,7,9,2,2,1),ncol=6, byrow=TRUE)
# ordinary Markov process
cmcre(y, par=c(-0.2,-1))
# random effect for the equilibrium probability
cmcre(y, par=c(-0.1,-2,-0.8))
# random effects for the equilibrium probability and sum of transition
#   intensities
cmcre(y, par=c(-0.1,-1.4,-0.5,-1))



