### Name: attrData-class
### Title: Class "attrData"
### Aliases: attrData-class
###   attrDataItem<-,attrData,character,character-method
###   attrDataItem,attrData,character,missing-method
###   attrDataItem,attrData,character,character-method
###   attrDefaults<-,attrData,character,ANY-method
###   attrDefaults<-,attrData,missing,list-method
###   attrDefaults,attrData,missing-method
###   attrDefaults,attrData,character-method initialize,attrData-method
### Keywords: classes

### ** Examples

defaultProps <- list(weight=1, color="blue", friends=c("Bob", "Alice"))
adat <- new("attrData", defaults=defaultProps)

## Get all defaults
attrDefaults(adat)

## Or get only a specific attribute
attrDefaults(adat, attr="color")

## Update default weight
attrDefaults(adat, attr="weight") <- 500

## Add new attribute
attrDefaults(adat, attr="length") <- 0

## Asking for the attributes of an element you haven't customized
## returns the defaults
attrDataItem(adat, x=c("n1", "n2"), attr="length")

## You can customize values
attrDataItem(adat, x=c("n1", "n2"), attr="length") <- 5



