### Name: odbcConnect
### Title: ODBC Open Connections
### Aliases: odbcConnect odbcDriverConnect odbcReConnect print.RODBC
###   odbcConnectAccess odbcConnectDbase odbcConnectExcel
### Keywords: IO database

### ** Examples
## Not run: 
##D # interactive specification under RGui
##D channel <- odbcDriverConnect("")
##D 
##D # MySQL on Windows -- MySQL maps to lower case on Windows only
##D channel <- odbcConnect("testdb", uid="ripley", case="tolower")
##D 
##D # Access
##D channel <- odbcConnect("testacc") # if this was set up as a DSN
##D channel2 <- odbcConnectAccess("test.mdb", uid="ripley")
##D 
##D # Excel
##D channel <- odbcConnect("bdr.xls") # if this was set up as a DSN
##D channel2 <-
##D  odbcDriverConnect("DRIVER=Microsoft Excel Driver (*.xls);DBQ=C:\bdr\hills.xls")
##D channel3 <- odbcConnectExcel("hills.xls")
##D 
##D # re-connection
##D odbcCloseAll()
##D channel <- odbcReConnect(channel) # must re-assign as the data may well change
## End(Not run)


