### Name: genSOAPClientInterface
### Title: Create R functions to access SOAP server methods
### Aliases: genSOAPClientInterface
### Keywords: interface programming

### ** Examples

 kegg = processWSDL("http://soap.genome.jp/KEGG.wsdl")
   # note that we force the use of the 1.1 name spaces to get arrays
   # handled correctly on the server side.
 iface = genSOAPClientInterface(def = kegg, nameSpaces = "1.1")

 tmp = processWSDL(system.file("examples", "KEGG.wsdl", package = "SSOAP"))
 ff = genSOAPClientInterface(tmp@operations[[1]], def = tmp, tmp@name, verbose=FALSE)

 as.character.Definition = function(x)  structure(x[["definition"]], names = x[["entry_id"]])
 as.character.list = function(x) sapply(x, as.character)

 o = ff@functions$list_organisms()

 as.character.list(o)



