### Name: addChildren
### Title: Add child nodes to an XML node
### Aliases: addChildren removeChildren addAttributes removeAttributes
###   addAttributes,XMLInternalElementNode-method
###   addAttributes,XMLNode-method
###   removeAttributes,XMLInternalElementNode-method
###   removeAttributes,XMLNode-method
### Keywords: IO programming

### ** Examples


b = newXMLNode("bob", namespace = c(r = "http://www.r-project.org", omg = "http://www.omegahat.org", ""))

cat(saveXML(b), "\n")

addAttributes(b, a = 1, b = "xyz", "r:version" = "2.4.1", "omg:len" = 3)
cat(saveXML(b), "\n")

removeAttributes(b, "a", "r:version")
cat(saveXML(b), "\n")

addChildren(b, newXMLNode("el", "Red", "Blue", "Green",
                           attrs = c(lang ="en")))

k = lapply(letters, newXMLNode)
addChildren(b, kids = k)

cat(saveXML(b), "\n")

removeChildren(b, "a", "b", "c", "z")

  # can mix numbers and names
removeChildren(b, 2, "e")  # d and e

cat(saveXML(b), "\n")

i = xmlChildren(b)[[5]]
xmlName(i)

 # have the identifiers
removeChildren(b, kids = c("m", "n", "q"))

## Not run: 
##D     # this won't work as the 10 gets coerced to a 
##D     # character vector element to be combined with 'w'
##D     # and there is no node name 10.
##D  removeChildren(b, kids = c(10, "w"))
## End(Not run)




