### Name: mapSub2Plate
### Title: Map subplate well ID and subplate ID to 96-well plate well ID
### Aliases: mapSub2Plate
### Keywords: manip

### ** Examples

  plcat = function(iw, x) {
    d = numeric(96)
    d[iw] = x
    for (i in 0:7)
      cat(sapply(d[(1:12)+i*12], function(s) { sprintf('%4s', s) }), '\n')
    cat('\n')
  }

  sub  = c(rep("a", 32), rep("b", 32), rep("c12", 16), rep("c34", 16))
  well = rep(1:32, 3)
  iw   = mapSub2Plate(sub, well)
  plcat(iw, paste(well))
  plcat(iw, sub)

  sub  = c(rep("1-48",  48), rep("49-96", 48))
  well = 1:96
  iw   = mapSub2Plate(sub, well)
  plcat(iw, paste(well))
  plcat(iw, sub)



