### Name: summary.mclustDAtrain
### Title: Models and classifications from mclustDAtrain
### Aliases: summary.mclustDAtrain
### Keywords: cluster

### ** Examples

set.seed(0)
n <- 100 ## create artificial data

x <- rbind(matrix(rnorm(n*2), n, 2) %*% diag(c(1,9)),
           matrix(rnorm(n*2), n, 2) %*% diag(c(1,9))[,2:1])
xclass <- c(rep(1,n),rep(2,n))
## Not run: 
##D par(pty = "s")
##D mclust2Dplot(x, classification = xclass, type="classification", ask=FALSE)
## End(Not run)

odd <- seq(1, 2*n, 2)
train <- mclustDAtrain(x[odd, ], labels = xclass[odd]) ## training step
summary(train)



