### Name: spinProj
### Title: Planar spin for random projections of data in more than two
###   dimensions modelled by an MVN mixture.
### Aliases: spinProj
### Keywords: cluster

### ** Examples

data(iris)
irisMatrix <- as.matrix(iris[,1:4])
irisClass <- iris[,5]

msEst <- mstepVVV(irisMatrix, unmap(irisClass))

par(pty = "s", mfrow = c(2,2))
spinProj(irisMatrix, seed = 1, truth=irisClass,
         mu = msEst$mu, sigma = msEst$sigma, z = msEst$z)
do.call("spinProj", c(list(data = irisMatrix, seeds = 2, truth=irisClass),
                           msEst))



