### Name: annaffyGO
### Title: Subset of annotation data file for GO in the hgu95av2 package
### Aliases: annaffyGO
### Keywords: datasets

### ** Examples

        require("annotate") || stop("annotate unavailable")
        xx <- ls(env = annaffyGO)
        if(length(xx) > 0){
                # Using get for value of the first key
                get(xx[1], annaffyGO )
                #Using mget for a few keys
                if(length(xx) >= 3){
                        mget(xx[1:3], annaffyGO, ifnotfound=NA )
                        #Using lookUp of annotate(> 1.3.4)
                        lookUp(xx[1:3],"annaffy","GO")
                }
                # Get GO ids. annotate >= 1.3.7
                goids <- lookUp(ls(annaffyGO)[1], "annaffy", "GO")
                if(!is.na(goids)){
                    # GO id of the first element
                    goids[[1]]$GOID
                    # Ontology category of the first element
                    goids[[1]]$Ontology
                    # Evidence code
                    goids[[1]]$Evidence
                }
        }



