### Name: GOLOCUSID2GO
### Title: Annotation of LocusLink identifiers by specific gene ontology
###   information for genes represented by the LocusLink identifiers
### Aliases: GOLOCUSID2GO
### Keywords: datasets

### ** Examples

        require("GO") || stop("GO unavailable")
        # Convert the environment object to a list
        xx <- as.list(GOLOCUSID2GO)
        # Remove LocusLink ids that are not mapped to any GO id
        xx <- xx[!is.na(xx)]
        if(length(xx) > 0){
                # Get the GO ids for the first two elents of xx
                goids  <- xx[1:2]
                # Get the evidence code goids
                evds <- sapply(goids, names)
        }



