### Name: GOLOCUSID2ALLGO
### Title: Annotation of LocusLink identifiers by specific and derived gene
###   ontology information regarding the genes corresponding to the
###   LocusLink identifiers
### Aliases: GOLOCUSID2ALLGO
### Keywords: datasets

### ** Examples

        require("GO") || stop("GO unavailable")
        # Convert the environment object to a list
        xx <- as.list(GOLOCUSID2ALLGO)
        # Remove LocusLink ids that are not mapped to any GO id
        xx <- xx[!is.na(xx)]
        if(length(xx) > 0){
                # Get the GO ids for the first two elents of xx
                goids  <- xx[1:2]
                # Get the evidence code goids
                evds <- sapply(goids, names)
        }



