\name{GOLL2GO}
\alias{GOLL2GO}
\title{Aannotation of LocusLink identifiers to the GO identifiers
  corresponding to the genes represented by the LocusLink identifiers}
\description{
This is an R environment (hash table) mapping LocusLink ids to GO ids
corresponding the genes represented by the LocusLink identifiers 
}
\details{
  LocusLink ids are keys and the corresponding GO ids are values. Values
  are named vectors of length 1 or greater depending on whether a given
  LocusLink id can be mapped to only one or more GO ids. Names for
  values are the evidence codes for the GO ids (if evidence code was
  provided by source data). The evidence codes in use include:

  IMP - inferred from mutant phenotype  

  IGI - inferred from genetic interaction

  IPI - inferred from physical interaction  

  ISS - inferred from sequence similarity  

  IDA - inferred from direct assay  

  IEP - inferred from expression pattern  

  IEA - inferred from electronic annotation  

  TAS - traceable author statement  

  NAS - non-traceable author statement  

  ND - no biological data available  

  IC - inferred by curator

  NA is assigned to LocusLink id that can not be mapped to any GO id at
  this time. 

  Mappings were based on data provided by:

  #LLSOURCE#

  Package built: #DATE#
}
\references{
    \url{http://www.ncbi.nlm.nih.gov/LocusLink} 
}
\examples{
  	require("GO") || stop("GO unavailable")
        # Convert the environment object to a list
	xx <- as.list(GOLL2GO)
        # Remove LocusLink ids that are not mapped to any GO id
        xx <- xx[!is.na(xx)]
	if(length(xx) > 0){
		# Get the GO ids for the first two elents of xx
		goids  <- xx[1:2]
                # Get the evidence code goids
                evds <- sapply(goids, names)
	}
}
\keyword{datasets}

