\name{GOBPCHILDREN}
\alias{GOBPCHILDREN}
\title{Annotation of GO identifiers by the GO identifiers of their
  direct chileren} 
\description{
This is an R environment (hash table) mapping GO ids to the GO
ids of their direct children under biological process (BP). Direct
children of a given GO id are those GO ids correponding to all the
children nodes that have direct link to the node for the GO id of
concern based on the directed acyclic graph defined by Gene Ontology
Consortium. GO terms for children nodes are more specific than that for
the parents 
}
\details{
  GO ids are keys and the corresponding children GO ids are values. Values are
  vectors of length 1 or greater depending on whether the GO id of concern
  has only one or more children. GO ids that do not have any child
  node are assigned NA as the values.

  Biological process is defined as the broad biological goals, such as
  mitosis or purine metabolism, that are accomplished by ordered
  assemblies of molecular functions as defined by Gene Ontology
  Consortium.
  
  Mappings were based on data provided by:

  #GOSOURCE#
  
  Package built: #DATE#
}
\references{
\url{http://www.geneontology.org/} and
\url{http://www.ncbi.nlm.nih.gov/LocusLink} 
}
\examples{
  require("GO", character.only = TRUE) || stop("GO unavailable")
  require("annotate", character.only = TRUE) || stop("annoate unavailable")
  # Convert the environment object to a list
  xx <- as.list(GOBPCHILDREN)
  # Remove GO ids that do not have any children
  xx <- xx[!is.na(xx)]
  if(length(xx) > 0){
     # Get the parent GO ids for the first elents of xx
        goids <- xx[[1]]
        # Find out the GO terms for the first parent goid
        GOID(GOTERM[[goids[1]]])
        Term(GOTERM[[goids[1]]])
        Synonym(GOTERM[[goids[1]]])
        Secondary(GOTERM[[goids[1]]])
        Definition(GOTERM[[goids[1]]])
        Category(GOTERM[[goids[1]]])
  }
}
\keyword{datasets}

