### Name: coordProj
### Title: Coordinate projections of data in more than two dimensions
###   modelled by an MVN mixture.
### Aliases: coordProj
### Keywords: cluster

### ** Examples

data(iris)
irisMatrix <- as.matrix(iris[,1:4])
irisClass <- iris[,5]

msEst <- mstepVVV(irisMatrix, unmap(irisClass))

par(pty = "s", mfrow = c(1,2))
coordProj(irisMatrix,dimens=c(2,3), truth = irisClass, 
          mu = msEst$mu, sigma = msEst$sigma, z = msEst$z)
do.call("coordProj", c(list(data=irisMatrix, dimens=c(2,3), truth=irisClass),
                       msEst))



