### Name: SparseM.solve
### Title: Linear Equation Solving for Sparse Matrices
### Aliases: SparseM.solve chol,ANY-method chol,matrix.csr-method
###   chol,matrix.csc-method chol,matrix-method chol chol.default
###   backsolve-methods backsolve,ANY-method backsolve solve
###   backsolve,matrix.csr.chol-method solve,ANY-method
###   solve,matrix.csr-method
### Keywords: algebra

### ** Examples

data(lsq)
class(lsq) # -> [1] "matrix.csc.hb"
model.matrix(lsq)->design.o
class(design.o) # -> "matrix.csr"
dim(design.o) # -> [1] 1850  712
y <- model.response(lsq) # extract the rhs
length(y) # [1] 1850
t(design.o)%*%design.o -> XpX
t(design.o)%*%y -> Xpy
chol(XpX)->chol.o
backsolve(chol.o,Xpy)-> b1 # least squares solutions in two steps
solve(XpX,Xpy) -> b2 # least squares estimates in one step



