### Name: MLIclust
### Title: An interface to various unsupervised machine learning methods
###   for exprSets
### Aliases: hclustB agnesB dianaB pamB bclustB trainInds xval silhouetteB
###   claraB distMat fannyB isoMDSB cmeansB cshellB kmeansB
###   agnesB,exprSet,numeric-method bclustB,exprSet,numeric-method
###   claraB,exprSet,numeric-method cmeansB,exprSet,numeric-method
###   hclustB,exprSet,numeric,missing-method
###   hclustB,exprSet,numeric,ANY-method
###   hclustB,exprSet,missing,numeric-method cshellB,exprSet,numeric-method
###   dianaB,exprSet,numeric-method fannyB,exprSet,numeric-method
###   kmeansB,exprSet,numeric-method pamB,exprSet,numeric-method
### Keywords: classif

### ** Examples

##get these from the source files
library(golubEsets)
data(golubMerge)
smallG <- golubMerge[1:60,]
set.seed(1234) # needed for nnet initialization
kmeansB( smallG, k=4 )
agnesB( smallG, k=5, height=0, FALSE )
dianaB( smallG, k=5, height=0, FALSE )
pamB( smallG, k=5, height=0, FALSE )
bclustB( smallG, k=5, height=0 )
cmeansB( smallG, k=5, height=0 )
cshellB( smallG, k=5, height=0 , iter.max=1)
#lcaB( BsmG, k=3 )
hclustB( smallG, k=4 )
hclustB( smallG, height=40000 )



